/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.system;

import com.jniwrapper.Function;
import com.jniwrapper.Library;
import com.jniwrapper.NoSuchFunctionException;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.Structure;
import com.jniwrapper.UInt32;
import com.jniwrapper.win32.HResult;
import com.jniwrapper.win32.LastErrorException;

public class DllVersionInfo
extends Structure {
    private static final String FUNCTION_DllGetVersion = "DllGetVersion";
    public static final int DLLVER_PLATFORM_WINDOWS = 1;
    public static final int DLLVER_PLATFORM_NT = 2;
    private UInt32 cbSize = new UInt32();
    private UInt32 dwMajorVersion = new UInt32();
    private UInt32 dwMinorVersion = new UInt32();
    private UInt32 dwBuildNumber = new UInt32();
    private UInt32 dwPlatformID = new UInt32();

    private DllVersionInfo() {
        this.init(new Parameter[]{this.cbSize, this.dwMajorVersion, this.dwMinorVersion, this.dwBuildNumber, this.dwPlatformID});
        this.cbSize.setValue((long)this.getLength());
    }

    public DllVersionInfo(String libraryName) throws NoSuchFunctionException {
        this();
        this.loadVersionInfo(libraryName);
    }

    public int getMajorVersion() {
        return (int)this.dwMajorVersion.getValue();
    }

    public int getMinorVersion() {
        return (int)this.dwMinorVersion.getValue();
    }

    public int getBuildNumber() {
        return (int)this.dwBuildNumber.getValue();
    }

    public int getPlatformID() {
        return (int)this.dwPlatformID.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadVersionInfo(String libraryName) throws NoSuchFunctionException {
        UnloadableLibrary library = new UnloadableLibrary(libraryName);
        try {
            Function function = library.getFunction(FUNCTION_DllGetVersion);
            HResult result = new HResult();
            long errorCode = function.invoke((Parameter)result, (Parameter)new Pointer((Parameter)this));
            int hResult = (int)result.getValue();
            if (hResult < 0) {
                throw new LastErrorException(errorCode, HResult.decodeHResult((int)hResult));
            }
        }
        finally {
            library.unload();
        }
    }

    public String toString() {
        return "DllVersionInfo: [Major Version = " + this.getMajorVersion() + "; Minor Version = " + this.getMinorVersion() + "; Build Number = " + this.getBuildNumber() + "; PlatformID = " + this.getPlatformID() + "]";
    }

    private static class UnloadableLibrary
    extends Library {
        public UnloadableLibrary(String name) {
            super(name);
        }

        public void unload() {
            super.unload();
        }
    }
}

