/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.shell;

import com.jniwrapper.Function;
import com.jniwrapper.LongInt;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.UInt;
import com.jniwrapper.win32.registry.RegistryException;
import com.jniwrapper.win32.registry.RegistryKey;
import com.jniwrapper.win32.registry.RegistryKeyType;
import com.jniwrapper.win32.registry.RegistryKeyValues;
import com.jniwrapper.win32.shell.Shell32;
import java.io.File;

public class FileTypeAssociation {
    private static final String FUNCTION_SHCHANGENOTIFY = "SHChangeNotify";
    private static final long SHCNE_ASSOCCHANGED = 0x8000000L;
    private static final long SHCNF_IDLIST = 0L;
    private String _extention;

    public FileTypeAssociation(String extention) {
        this._extention = extention.startsWith(".") ? extention : "." + extention;
    }

    public void createAssociation(File executable, String progID) {
        if (!executable.isFile()) {
            throw new IllegalArgumentException("File not found.");
        }
        String commandLine = "\"" + executable.getAbsolutePath() + "\" \"%1\"";
        this.createAssociation(commandLine, progID);
    }

    public void createAssociation(String commandLine, String progID) {
        RegistryKey registryKey = RegistryKey.CLASSES_ROOT.createSubKey(progID + "\\shell\\open\\command", true);
        RegistryKeyValues values = registryKey.values();
        if (commandLine != null) {
            values.put((Object)"", (Object)commandLine);
        } else {
            values.put((Object)"", (Object)"");
        }
        registryKey.close();
        registryKey = RegistryKey.CLASSES_ROOT.createSubKey(this.getExtention(), true);
        values = registryKey.values();
        values.put((Object)"", (Object)progID, RegistryKeyType.SZ);
        registryKey.close();
        this.changeNotify();
    }

    public void removeAssociation() {
        try {
            RegistryKey.CLASSES_ROOT.deleteSubKey(this.getExtention());
        }
        catch (RegistryException e) {
            // empty catch block
        }
        try {
            RegistryKey.CURRENT_USER.openSubKey("Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts").deleteSubKey(this.getExtention());
        }
        catch (RegistryException e) {
            // empty catch block
        }
        try {
            RegistryKey.LOCAL_MACHINE.openSubKey("SOFTWARE\\Classes").deleteSubKey(this.getExtention());
        }
        catch (RegistryException registryException) {
            // empty catch block
        }
        this.changeNotify();
    }

    public String getDefaultCommand() {
        RegistryKey key = RegistryKey.CLASSES_ROOT.openSubKey(this.getProgID());
        key = key.openSubKey("\\shell\\open\\command");
        RegistryKeyValues values = key.values();
        return values.get((Object)"").toString();
    }

    public String getProgID() {
        RegistryKeyValues values = RegistryKey.CLASSES_ROOT.openSubKey(this.getExtention()).values();
        return values.get((Object)"").toString();
    }

    public boolean isRegistered() {
        try {
            RegistryKey.CLASSES_ROOT.openSubKey(this.getExtention());
        }
        catch (RegistryException e) {
            return false;
        }
        return true;
    }

    public String getExtention() {
        return this._extention;
    }

    private void changeNotify() {
        Function function = Shell32.getInstance().getFunction(FUNCTION_SHCHANGENOTIFY.toString());
        function.invoke(null, (Parameter)new LongInt(0x8000000L), (Parameter)new UInt(0L), (Parameter)new Pointer(null, true), (Parameter)new Pointer(null, true));
    }
}

