/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.dde;

import com.jniwrapper.util.Logger;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.MessageLoopThread;
import com.jniwrapper.win32.dde.DdeCallback;
import com.jniwrapper.win32.dde.DdeException;
import com.jniwrapper.win32.dde.DdeFunctions;
import com.jniwrapper.win32.dde.DdeServiceEventHandler;

public class DdeService {
    private static final Logger _log = Logger.getInstance((Class)(class$com$jniwrapper$win32$dde$DdeService == null ? (class$com$jniwrapper$win32$dde$DdeService = DdeService.class$("com.jniwrapper.win32.dde.DdeService")) : class$com$jniwrapper$win32$dde$DdeService));
    private String _name;
    private boolean _registered;
    private long _idInst;
    private DdeCallback _callback;
    private DdeException _exception;
    private MessageLoopThread _messageLoop;
    static /* synthetic */ Class class$com$jniwrapper$win32$dde$DdeService;

    public DdeService(String name) {
        this._name = name;
        Runnable runnable = new Runnable(){

            public void run() {
                DdeService.this._callback = new DdeCallback();
            }
        };
        try {
            this.getMessageLoop().doInvokeAndWait(runnable);
        }
        catch (Exception e) {
            _log.error((Object)"", (Throwable)e);
        }
    }

    private MessageLoopThread getMessageLoop() {
        if (this._messageLoop == null) {
            this._messageLoop = new MessageLoopThread();
            this._messageLoop.doStart();
        }
        return this._messageLoop;
    }

    public void register() throws DdeException {
        this._exception = null;
        if (!this._registered) {
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        DdeService.this._idInst = DdeFunctions.ddeInitialize(DdeService.this._callback, 0L);
                        DdeService.this._callback.setIdInst(DdeService.this._idInst);
                        DdeService.this._registered = true;
                        Handle name = DdeFunctions.createStringHandle(DdeService.this._idInst, DdeService.this._name);
                        DdeFunctions.nameService(DdeService.this._idInst, name, 1L);
                        DdeFunctions.freeStringHandle(DdeService.this._idInst, name);
                    }
                    catch (DdeException e) {
                        DdeService.this._exception = e;
                    }
                }
            };
            try {
                this.getMessageLoop().doInvokeAndWait(runnable);
            }
            catch (Exception e) {
                _log.error((Object)"", (Throwable)e);
            }
            if (this._exception != null) {
                throw this._exception;
            }
        }
    }

    public boolean isRegistered() {
        return this._registered;
    }

    public void unregister() throws DdeException {
        this._exception = null;
        if (this._registered) {
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        Handle name = DdeFunctions.createStringHandle(DdeService.this._idInst, DdeService.this._name);
                        DdeFunctions.nameService(DdeService.this._idInst, name, 2L);
                        DdeFunctions.freeStringHandle(DdeService.this._idInst, name);
                        DdeFunctions.ddeUninitialize(DdeService.this._idInst);
                        DdeService.this._registered = false;
                    }
                    catch (DdeException e) {
                        DdeService.this._exception = e;
                    }
                }
            };
            try {
                this.getMessageLoop().doInvokeAndWait(runnable);
            }
            catch (Exception e) {
                _log.error((Object)"", (Throwable)e);
            }
            if (this._exception != null) {
                throw this._exception;
            }
        }
    }

    public void setEventHandler(final DdeServiceEventHandler eventHandler) {
        if (eventHandler == null) {
            throw new IllegalArgumentException("Event handler must be not null.");
        }
        Runnable runnable = new Runnable(){

            public void run() {
                DdeService.this._callback.addServerEventHandler(DdeService.this._name, eventHandler);
            }
        };
        try {
            this.getMessageLoop().doInvokeAndWait(runnable);
        }
        catch (Exception e) {
            _log.error((Object)"", (Throwable)e);
            e.printStackTrace();
        }
    }

    public void removeEventHandler() {
        Runnable runnable = new Runnable(){

            public void run() {
                DdeService.this._callback.removeServerEventHandler(DdeService.this._name);
            }
        };
        try {
            this.getMessageLoop().doInvokeAndWait(runnable);
        }
        catch (Exception e) {
            _log.error((Object)"", (Throwable)e);
        }
    }

    public String getName() {
        return this._name;
    }

    public void postAdvise(final String topic, final String item) throws DdeException {
        this._exception = null;
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    DdeFunctions.postAdvise(DdeService.this._idInst, topic, item);
                }
                catch (DdeException e) {
                    DdeService.this._exception = e;
                }
            }
        };
        try {
            this.getMessageLoop().doInvokeAndWait(runnable);
        }
        catch (Exception e) {
            _log.error((Object)"", (Throwable)e);
        }
        if (this._exception != null) {
            throw this._exception;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

