/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.dde;

import com.jniwrapper.Callback;
import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.IntBool;
import com.jniwrapper.Parameter;
import com.jniwrapper.PlatformContext;
import com.jniwrapper.Pointer;
import com.jniwrapper.PrimitiveArray;
import com.jniwrapper.Str;
import com.jniwrapper.UInt;
import com.jniwrapper.UInt32;
import com.jniwrapper.win32.FunctionName;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.dde.DdeException;
import com.jniwrapper.win32.ui.User32;

class DdeFunctions {
    private static final FunctionName FUNCTION_INITIALIZE = new FunctionName("DdeInitialize");
    private static final String FUNCTION_GETLASTERROR = "DdeGetLastError";
    private static final String FUNCTION_UNINITIALIZE = "DdeUninitialize";
    private static final String FUNCTION_CONNECT = "DdeConnect";
    private static final String FUNCTION_RECONNECT = "DdeReconnect";
    private static final String FUNCTION_DISCONNECT = "DdeDisconnect";
    private static final String FUNCTION_CLIENTTRANSACTION = "DdeClientTransaction";
    private static final String FUNCTION_CREATEDATAHANDLE = "DdeCreateDataHandle";
    private static final String FUNCTION_GETDATA = "DdeGetData";
    private static final String FUNCTION_FREESTRINGHANDLE = "DdeFreeStringHandle";
    private static final String FUNCTION_FREEDATAHANDLE = "DdeFreeDataHandle";
    private static final String FUNCTION_NAMESERVICE = "DdeNameService";
    private static final FunctionName FUNCTION_CREATESTRINGHANDLE = new FunctionName("DdeCreateStringHandle");
    private static final FunctionName FUNCTION_QUERYSTRING = new FunctionName("DdeQueryString");
    private static final String FUNCTION_POSTADVISE = "DdePostAdvise";
    private static final String FUNCTION_ABANDONTRANSACTION = "DdeAbandonTransaction";
    public static final long APPCLASS_STANDARD = 0L;
    public static final long APPCLASS_MONITOR = 1L;
    public static final long APPCMD_CLIENTONLY = 16L;
    public static final long APPCMD_FILTERINITS = 32L;
    public static final long CBF_FAIL_SELFCONNECTIONS = 4096L;
    public static final long CBF_FAIL_CONNECTIONS = 8192L;
    public static final long CBF_FAIL_ADVISES = 16384L;
    public static final long CBF_FAIL_EXECUTES = 32768L;
    public static final long CBF_FAIL_POKES = 65536L;
    public static final long CBF_FAIL_REQUESTS = 131072L;
    public static final long CBF_FAIL_ALLSVRXACTIONS = 258048L;
    public static final long CBF_SKIP_CONNECT_CONFIRMS = 262144L;
    public static final long CBF_SKIP_REGISTRATIONS = 524288L;
    public static final long CBF_SKIP_UNREGISTRATIONS = 0x100000L;
    public static final long CBF_SKIP_DISCONNECTS = 0x200000L;
    public static final long CBF_SKIP_ALLNOTIFICATIONS = 0x3C0000L;
    public static final long MF_HSZ_INFO = 0x1000000L;
    public static final long MF_SENDMSGS = 0x2000000L;
    public static final long MF_POSTMSGS = 0x4000000L;
    public static final long MF_CALLBACKS = 0x8000000L;
    public static final long MF_ERRORS = 0x10000000L;
    public static final long MF_LINKS = 0x20000000L;
    public static final long MF_CONV = 0x40000000L;
    public static final int XTYPF_NOBLOCK = 2;
    public static final int XTYPF_NODATA = 4;
    public static final int XTYPF_ACKREQ = 8;
    public static final int XCLASS_MASK = 64512;
    public static final int XCLASS_BOOL = 4096;
    public static final int XCLASS_DATA = 8192;
    public static final int XCLASS_FLAGS = 16384;
    public static final int XCLASS_NOTIFICATION = 32768;
    public static final int XTYP_ERROR = 32770;
    public static final int XTYP_ADVDATA = 16400;
    public static final int XTYP_ADVREQ = 8226;
    public static final int XTYP_ADVSTART = 4144;
    public static final int XTYP_ADVSTOP = 32832;
    public static final int XTYP_EXECUTE = 16464;
    public static final int XTYP_CONNECT = 4194;
    public static final int XTYP_CONNECT_CONFIRM = 32882;
    public static final int XTYP_XACT_COMPLETE = 32896;
    public static final int XTYP_POKE = 16528;
    public static final int XTYP_REGISTER = 32930;
    public static final int XTYP_REQUEST = 8368;
    public static final int XTYP_DISCONNECT = 32962;
    public static final int XTYP_UNREGISTER = 32978;
    public static final int XTYP_WILDCONNECT = 8418;
    public static final long XTYP_MASK = 240L;
    public static final long XTYP_SHIFT = 4L;
    public static final long TIMEOUT_ASYNC = 0xFFFFFFFFL;
    public static final long QID_SYNC = 0xFFFFFFFFL;
    public static final long CP_WINUNICODE = 1200L;
    public static final long CP_WINANSI = 1004L;
    public static final long HDATA_APPOWNED = 1L;
    public static final long EC_ENABLEALL = 0L;
    public static final long DNS_REGISTER = 1L;
    public static final long DNS_UNREGISTER = 2L;
    public static final int DDE_FACK = 32768;
    public static final int DDE_FBUSY = 16384;
    public static final int DDE_FDEFERUPD = 16384;
    public static final int DDE_FACKREQ = 32768;
    public static final int DDE_FRELEASE = 8192;
    public static final int DDE_FREQUESTED = 4096;
    public static final int DDE_FAPPSTATUS = 255;
    public static final int DDE_FNOTPROCESSED = 0;
    static /* synthetic */ Class class$com$jniwrapper$UInt8;

    DdeFunctions() {
    }

    private static long getCodePage() {
        if (PlatformContext.isUnicode()) {
            return 1200L;
        }
        return 1004L;
    }

    public static long ddeInitialize(Callback callback, long cmd) throws DdeException {
        Function function = User32.getInstance().getFunction(FUNCTION_INITIALIZE.toString());
        UInt result = new UInt();
        UInt32 idInst = new UInt32(0L);
        function.invoke((Parameter)result, (Parameter)new Pointer((Parameter)idInst), (Parameter)callback, (Parameter)new UInt32(cmd), (Parameter)new UInt32(0L));
        if (result.getValue() != 0L) {
            throw new DdeException(DdeFunctions.getLastError(idInst.getValue()));
        }
        return idInst.getValue();
    }

    public static void ddeUninitialize(long idInst) throws DdeException {
        Function function = User32.getInstance().getFunction(FUNCTION_UNINITIALIZE);
        IntBool result = new IntBool();
        function.invoke((Parameter)result, (Parameter)new UInt32(idInst));
        if (result.getValue() == 0L) {
            throw new DdeException(DdeFunctions.getLastError(idInst));
        }
    }

    public static int getLastError(long idInst) {
        Function function = User32.getInstance().getFunction(FUNCTION_GETLASTERROR);
        UInt result = new UInt();
        function.invoke((Parameter)result, (Parameter)new UInt32(idInst));
        return (int)result.getValue();
    }

    public static Handle createStringHandle(long idInst, String string) throws DdeException {
        Function function = User32.getInstance().getFunction(FUNCTION_CREATESTRINGHANDLE.toString());
        Handle result = new Handle();
        function.invoke((Parameter)result, (Parameter)new UInt32(idInst), (Parameter)new Str(string), (Parameter)new Int(DdeFunctions.getCodePage()));
        if (result.getValue() == 0L) {
            throw new DdeException(DdeFunctions.getLastError(idInst));
        }
        return result;
    }

    public static String queryString(long idInst, Handle handle) throws DdeException {
        Function function = User32.getInstance().getFunction(FUNCTION_QUERYSTRING.toString());
        UInt32 result = new UInt32();
        Str str = new Str(255);
        function.invoke((Parameter)result, new Parameter[]{new UInt32(idInst), handle, new Pointer((Parameter)str), new UInt32(255L), new Int(DdeFunctions.getCodePage())});
        if (result.getValue() == 0L) {
            throw new DdeException(DdeFunctions.getLastError(idInst));
        }
        return str.getValue();
    }

    public static Handle connect(long idInst, String service, String topic) throws DdeException {
        Function function = User32.getInstance().getFunction(FUNCTION_CONNECT);
        Handle result = new Handle();
        Handle hService = DdeFunctions.createStringHandle(idInst, service);
        Handle hTopic = DdeFunctions.createStringHandle(idInst, topic);
        function.invoke((Parameter)result, (Parameter)new UInt32(idInst), (Parameter)hService, (Parameter)hTopic, (Parameter)new Pointer(null, true));
        DdeFunctions.freeStringHandle(idInst, hService);
        DdeFunctions.freeStringHandle(idInst, hTopic);
        if (result.getValue() == 0L) {
            throw new DdeException(DdeFunctions.getLastError(idInst));
        }
        return result;
    }

    public static Handle reconnect(long idInst, Handle conv) throws DdeException {
        Function function = User32.getInstance().getFunction(FUNCTION_RECONNECT);
        Handle result = new Handle();
        function.invoke((Parameter)result, (Parameter)conv);
        if (result.getValue() == 0L) {
            throw new DdeException(DdeFunctions.getLastError(idInst));
        }
        return result;
    }

    public static void disconnect(long idInst, Handle conv) throws DdeException {
        Function function = User32.getInstance().getFunction(FUNCTION_DISCONNECT);
        IntBool result = new IntBool();
        function.invoke((Parameter)result, (Parameter)conv);
        if (result.getValue() == 0L) {
            throw new DdeException(DdeFunctions.getLastError(idInst));
        }
    }

    public static Handle clientTransaction(long idInst, Handle data, Handle conv, Handle item, long type, long format, long timeout) throws DdeException {
        Function function = User32.getInstance().getFunction(FUNCTION_CLIENTTRANSACTION);
        Handle retVal = new Handle();
        UInt32 result = new UInt32();
        function.invoke((Parameter)retVal, new Parameter[]{data, new UInt32(-1L), conv, item, new UInt(format), new UInt(type), new UInt32(timeout), new Pointer((Parameter)result)});
        if (retVal.getValue() == 0L) {
            throw new DdeException(DdeFunctions.getLastError(idInst));
        }
        if (timeout == 0xFFFFFFFFL) {
            return new Handle(result.getValue());
        }
        return retVal;
    }

    public static Handle clientTransaction(long idInst, String data, Handle conv, Handle item, long type, long format, long timeout) throws DdeException {
        Function function = User32.getInstance().getFunction(FUNCTION_CLIENTTRANSACTION);
        Handle retVal = new Handle();
        UInt32 result = new UInt32();
        Str str = new Str(data);
        function.invoke((Parameter)retVal, new Parameter[]{str, new UInt32((long)str.getLength()), conv, item, new UInt(format), new UInt(type), new UInt32(timeout), new Pointer((Parameter)result)});
        if (retVal.getValue() == 0L) {
            throw new DdeException(DdeFunctions.getLastError(idInst));
        }
        if (timeout == 0xFFFFFFFFL) {
            return new Handle(result.getValue());
        }
        return retVal;
    }

    public static Handle createDataHandle(long idInst, byte[] data, int offset, long format, Handle item) throws DdeException {
        Function function = User32.getInstance().getFunction(FUNCTION_CREATEDATAHANDLE);
        PrimitiveArray paData = new PrimitiveArray(data);
        Handle retVal = new Handle();
        function.invoke((Parameter)retVal, new Parameter[]{new UInt32(idInst), new Pointer((Parameter)paData), new UInt32((long)paData.getElementCount()), new UInt32((long)offset), item == null ? new Handle() : item, new UInt(format), new UInt(1L)});
        if (retVal.getValue() == 0L) {
            throw new DdeException(DdeFunctions.getLastError(idInst));
        }
        return retVal;
    }

    public static byte[] getData(Handle data) {
        Function function = User32.getInstance().getFunction(FUNCTION_GETDATA);
        UInt32 count = new UInt32();
        function.invoke((Parameter)count, (Parameter)data, (Parameter)new Pointer(null, true), (Parameter)new UInt32(0L), (Parameter)new UInt32(0L));
        PrimitiveArray retVal = new PrimitiveArray(class$com$jniwrapper$UInt8 == null ? (class$com$jniwrapper$UInt8 = DdeFunctions.class$("com.jniwrapper.UInt8")) : class$com$jniwrapper$UInt8, (int)count.getValue());
        function.invoke((Parameter)count, (Parameter)data, (Parameter)new Pointer((Parameter)retVal), (Parameter)new UInt32(count.getValue()), (Parameter)new UInt32(0L));
        return retVal.getBytes();
    }

    public static void freeStringHandle(long idInst, Handle handle) throws DdeException {
        Function function = User32.getInstance().getFunction(FUNCTION_FREESTRINGHANDLE);
        IntBool result = new IntBool();
        function.invoke((Parameter)result, (Parameter)new UInt32(idInst), (Parameter)handle);
        if (result.getValue() == 0L) {
            throw new DdeException(DdeFunctions.getLastError(idInst));
        }
    }

    public static void freeDataHandle(long idInst, Handle handle) throws DdeException {
        Function function = User32.getInstance().getFunction(FUNCTION_FREEDATAHANDLE);
        IntBool result = new IntBool();
        function.invoke((Parameter)result, (Parameter)handle);
        if (result.getValue() == 0L) {
            throw new DdeException(DdeFunctions.getLastError(idInst));
        }
    }

    public static void nameService(long idInst, Handle service, long flag) throws DdeException {
        Function function = User32.getInstance().getFunction(FUNCTION_NAMESERVICE);
        Handle result = new Handle();
        function.invoke((Parameter)result, (Parameter)new UInt32(idInst), (Parameter)service, (Parameter)new UInt(0L), (Parameter)new UInt(flag));
        if (result.getValue() == 0L) {
            throw new DdeException(DdeFunctions.getLastError(idInst));
        }
    }

    public static void postAdvise(long idInst, String topic, String item) throws DdeException {
        Function function = User32.getInstance().getFunction(FUNCTION_POSTADVISE);
        IntBool result = new IntBool();
        Handle hTopic = DdeFunctions.createStringHandle(idInst, topic);
        Handle hItem = DdeFunctions.createStringHandle(idInst, item);
        function.invoke((Parameter)result, (Parameter)new UInt32(idInst), (Parameter)hTopic, (Parameter)hItem);
        if (result.getValue() == 0L) {
            throw new DdeException(DdeFunctions.getLastError(idInst));
        }
    }

    public static void abandonTransaction(long idInst, Handle conv, long transactionID) throws DdeException {
        Function function = User32.getInstance().getFunction(FUNCTION_ABANDONTRANSACTION);
        IntBool result = new IntBool();
        function.invoke((Parameter)result, (Parameter)new UInt32(idInst), (Parameter)conv, (Parameter)new UInt32(transactionID));
        if (result.getValue() == 0L) {
            throw new DdeException(DdeFunctions.getLastError(idInst));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

