/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.dde;

import com.jniwrapper.util.Logger;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.MessageLoopThread;
import com.jniwrapper.win32.dde.DdeCallback;
import com.jniwrapper.win32.dde.DdeClientEventHandler;
import com.jniwrapper.win32.dde.DdeException;
import com.jniwrapper.win32.dde.DdeFunctions;
import com.jniwrapper.win32.dde.DdeItem;

public class DdeClient {
    private static final Logger _log = Logger.getInstance((Class)(class$com$jniwrapper$win32$dde$DdeClient == null ? (class$com$jniwrapper$win32$dde$DdeClient = DdeClient.class$("com.jniwrapper.win32.dde.DdeClient")) : class$com$jniwrapper$win32$dde$DdeClient));
    private String _service;
    private String _topic;
    private Handle _conv;
    private long _idInst;
    private DdeCallback _callback;
    private boolean _connected;
    private DdeException _exception;
    private MessageLoopThread _messageLoop;
    private DdeClientEventHandler _clientEventHandler;
    static /* synthetic */ Class class$com$jniwrapper$win32$dde$DdeClient;

    public DdeClient(String service, String topic) {
        this._service = service;
        this._topic = topic;
        this._connected = false;
        Runnable runnable = new Runnable(){

            public void run() {
                DdeClient.this._callback = new DdeCallback();
            }
        };
        try {
            this.getMessageLoop().doInvokeAndWait(runnable);
        }
        catch (Exception e) {
            _log.error((Object)"", (Throwable)e);
        }
    }

    private MessageLoopThread getMessageLoop() {
        if (this._messageLoop == null) {
            this._messageLoop = new MessageLoopThread();
            this._messageLoop.doStart();
        }
        return this._messageLoop;
    }

    public void connect() throws DdeException {
        this._exception = null;
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    if (!DdeClient.this._connected) {
                        DdeClient.this._idInst = DdeFunctions.ddeInitialize(DdeClient.this._callback, 0L);
                        DdeClient.this._callback.setIdInst(DdeClient.this._idInst);
                        DdeClient.this._connected = true;
                    }
                    DdeClient.this._conv = DdeFunctions.connect(DdeClient.this._idInst, DdeClient.this._service, DdeClient.this._topic);
                    if (DdeClient.this._clientEventHandler != null) {
                        DdeClient.this._callback.addClientEventHandler(DdeClient.this._conv, DdeClient.this._clientEventHandler);
                    }
                }
                catch (DdeException e) {
                    DdeClient.this._exception = e;
                }
            }
        };
        try {
            this.getMessageLoop().doInvokeAndWait(runnable);
        }
        catch (Exception e) {
            _log.error((Object)"", (Throwable)e);
        }
        if (this._exception != null) {
            throw this._exception;
        }
    }

    public void disconnect() throws DdeException {
        this._exception = null;
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    if (DdeClient.this._connected) {
                        DdeFunctions.disconnect(DdeClient.this._idInst, DdeClient.this._conv);
                        DdeFunctions.ddeUninitialize(DdeClient.this._idInst);
                        DdeClient.this._connected = false;
                    }
                }
                catch (DdeException e) {
                    DdeClient.this._exception = e;
                }
            }
        };
        try {
            this.getMessageLoop().doInvokeAndWait(runnable);
        }
        catch (Exception e) {
            _log.error((Object)"", (Throwable)e);
        }
        if (this._exception != null) {
            throw this._exception;
        }
    }

    public long getAsync(final DdeItem item) throws DdeException {
        final Handle[] result = new Handle[1];
        this._exception = null;
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    Handle hItem = DdeFunctions.createStringHandle(DdeClient.this._idInst, item.getName());
                    result[0] = DdeFunctions.clientTransaction(DdeClient.this._idInst, new Handle(), DdeClient.this._conv, hItem, 8368L, item.getFormat(), 0xFFFFFFFFL);
                    DdeFunctions.freeStringHandle(DdeClient.this._idInst, hItem);
                }
                catch (DdeException e) {
                    DdeClient.this._exception = e;
                }
            }
        };
        try {
            this.getMessageLoop().doInvokeAndWait(runnable);
        }
        catch (Exception e) {
            _log.error((Object)"", (Throwable)e);
        }
        if (this._exception != null) {
            throw this._exception;
        }
        return result[0].getValue();
    }

    public byte[] get(final DdeItem item, final long timeout) throws DdeException {
        final Object[] result = new Object[1];
        this._exception = null;
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    Handle hItem = DdeFunctions.createStringHandle(DdeClient.this._idInst, item.getName());
                    Handle data = DdeFunctions.clientTransaction(DdeClient.this._idInst, new Handle(), DdeClient.this._conv, hItem, 8368L, item.getFormat(), timeout);
                    byte[] resData = DdeFunctions.getData(data);
                    DdeFunctions.freeStringHandle(DdeClient.this._idInst, hItem);
                    DdeFunctions.freeDataHandle(DdeClient.this._idInst, data);
                    result[0] = resData;
                }
                catch (DdeException e) {
                    DdeClient.this._exception = e;
                }
            }
        };
        try {
            this.getMessageLoop().doInvokeAndWait(runnable);
        }
        catch (Exception e) {
            _log.error((Object)"", (Throwable)e);
        }
        if (this._exception != null) {
            throw this._exception;
        }
        return (byte[])result[0];
    }

    public long sendAsync(final DdeItem item, final byte[] data) throws DdeException {
        final Handle[] result = new Handle[1];
        this._exception = null;
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    Handle hItem = DdeFunctions.createStringHandle(DdeClient.this._idInst, item.getName());
                    Handle hData = DdeFunctions.createDataHandle(DdeClient.this._idInst, data, 0, item.getFormat(), hItem);
                    result[0] = DdeFunctions.clientTransaction(DdeClient.this._idInst, hData, DdeClient.this._conv, hItem, 16528L, item.getFormat(), 0xFFFFFFFFL);
                    DdeFunctions.freeStringHandle(DdeClient.this._idInst, hItem);
                    DdeFunctions.freeDataHandle(DdeClient.this._idInst, hData);
                }
                catch (DdeException e) {
                    DdeClient.this._exception = e;
                }
            }
        };
        try {
            this.getMessageLoop().doInvokeAndWait(runnable);
        }
        catch (Exception e) {
            _log.error((Object)"", (Throwable)e);
        }
        if (this._exception != null) {
            throw this._exception;
        }
        return result[0].getValue();
    }

    public void send(final DdeItem item, final byte[] data, final long timeout) throws DdeException {
        this._exception = null;
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    Handle hItem = DdeFunctions.createStringHandle(DdeClient.this._idInst, item.getName());
                    Handle hData = DdeFunctions.createDataHandle(DdeClient.this._idInst, data, 0, item.getFormat(), hItem);
                    DdeFunctions.clientTransaction(DdeClient.this._idInst, hData, DdeClient.this._conv, hItem, 16528L, item.getFormat(), timeout);
                    DdeFunctions.freeStringHandle(DdeClient.this._idInst, hItem);
                    DdeFunctions.freeDataHandle(DdeClient.this._idInst, hData);
                }
                catch (DdeException e) {
                    DdeClient.this._exception = e;
                }
            }
        };
        try {
            this.getMessageLoop().doInvokeAndWait(runnable);
        }
        catch (Exception e) {
            _log.error((Object)"", (Throwable)e);
        }
        if (this._exception != null) {
            throw this._exception;
        }
    }

    public long executeAsync(final String command) throws DdeException {
        final Handle[] result = new Handle[1];
        this._exception = null;
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    result[0] = DdeFunctions.clientTransaction(DdeClient.this._idInst, command, DdeClient.this._conv, new Handle(), 16464L, 1L, 0xFFFFFFFFL);
                }
                catch (DdeException e) {
                    DdeClient.this._exception = e;
                }
            }
        };
        try {
            this.getMessageLoop().doInvokeAndWait(runnable);
        }
        catch (Exception e) {
            _log.error((Object)"", (Throwable)e);
        }
        if (this._exception != null) {
            throw this._exception;
        }
        return result[0].getValue();
    }

    public void execute(final String command, final long timeout) throws DdeException {
        this._exception = null;
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    DdeFunctions.clientTransaction(DdeClient.this._idInst, command, DdeClient.this._conv, new Handle(), 16464L, 1L, timeout);
                }
                catch (DdeException e) {
                    DdeClient.this._exception = e;
                }
            }
        };
        try {
            this.getMessageLoop().doInvokeAndWait(runnable);
        }
        catch (Exception e) {
            _log.error((Object)"", (Throwable)e);
        }
        if (this._exception != null) {
            throw this._exception;
        }
    }

    public long startAdviseLoopAsync(final DdeItem item, final boolean sendData, final boolean sync) throws DdeException {
        final Handle[] result = new Handle[1];
        this._exception = null;
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    Handle hItem = DdeFunctions.createStringHandle(DdeClient.this._idInst, item.getName());
                    long flag = 4144L;
                    if (!sendData) {
                        flag |= 4L;
                    }
                    if (sync) {
                        flag |= 8L;
                    }
                    result[0] = DdeFunctions.clientTransaction(DdeClient.this._idInst, new Handle(), DdeClient.this._conv, hItem, flag, item.getFormat(), 0xFFFFFFFFL);
                    DdeFunctions.freeStringHandle(DdeClient.this._idInst, hItem);
                }
                catch (DdeException e) {
                    DdeClient.this._exception = e;
                }
            }
        };
        try {
            this.getMessageLoop().doInvokeAndWait(runnable);
        }
        catch (Exception e) {
            _log.error((Object)"", (Throwable)e);
        }
        if (this._exception != null) {
            throw this._exception;
        }
        return result[0].getValue();
    }

    public void startAdviseLoop(final DdeItem item, final boolean sendData, final boolean sync, final long timeout) throws DdeException {
        this._exception = null;
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    Handle hItem = DdeFunctions.createStringHandle(DdeClient.this._idInst, item.getName());
                    long flag = 4144L;
                    if (!sendData) {
                        flag |= 4L;
                    }
                    if (sync) {
                        flag |= 8L;
                    }
                    DdeFunctions.clientTransaction(DdeClient.this._idInst, new Handle(), DdeClient.this._conv, hItem, flag, item.getFormat(), timeout);
                    DdeFunctions.freeStringHandle(DdeClient.this._idInst, hItem);
                }
                catch (DdeException e) {
                    DdeClient.this._exception = e;
                }
            }
        };
        try {
            this.getMessageLoop().doInvokeAndWait(runnable);
        }
        catch (Exception e) {
            _log.error((Object)"", (Throwable)e);
        }
        if (this._exception != null) {
            throw this._exception;
        }
    }

    public long stopAdviseLoopAsync(final DdeItem item) throws DdeException {
        final Handle[] result = new Handle[1];
        this._exception = null;
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    Handle hItem = DdeFunctions.createStringHandle(DdeClient.this._idInst, item.getName());
                    result[0] = DdeFunctions.clientTransaction(DdeClient.this._idInst, new Handle(), DdeClient.this._conv, hItem, 32832L, 0L, 0xFFFFFFFFL);
                    DdeFunctions.freeStringHandle(DdeClient.this._idInst, hItem);
                }
                catch (DdeException e) {
                    DdeClient.this._exception = e;
                }
            }
        };
        try {
            this.getMessageLoop().doInvokeAndWait(runnable);
        }
        catch (Exception e) {
            _log.error((Object)"", (Throwable)e);
        }
        if (this._exception != null) {
            throw this._exception;
        }
        return result[0].getValue();
    }

    public void stopAdviseLoop(final DdeItem item, final long timeout) throws DdeException {
        this._exception = null;
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    Handle hItem = DdeFunctions.createStringHandle(DdeClient.this._idInst, item.getName());
                    DdeFunctions.clientTransaction(DdeClient.this._idInst, new Handle(), DdeClient.this._conv, hItem, 32832L, 0L, timeout);
                    DdeFunctions.freeStringHandle(DdeClient.this._idInst, hItem);
                }
                catch (DdeException e) {
                    DdeClient.this._exception = e;
                }
            }
        };
        try {
            this.getMessageLoop().doInvokeAndWait(runnable);
        }
        catch (Exception e) {
            _log.error((Object)"", (Throwable)e);
        }
        if (this._exception != null) {
            throw this._exception;
        }
    }

    public String getServiceName() {
        return this._service;
    }

    public String getTopicName() {
        return this._topic;
    }

    public void abandonTransaction(long transactionID) throws DdeException {
        DdeFunctions.abandonTransaction(this._idInst, this._conv, transactionID);
    }

    public void setEventHandler(DdeClientEventHandler eventHandler) {
        if (this._conv == null) {
            this._clientEventHandler = eventHandler;
        } else {
            this._callback.addClientEventHandler(this._conv, eventHandler);
        }
    }

    public void removeEventHandler() {
        this._callback.removeClientEventHandler(this._conv);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

