/*
 * Decompiled with CFR 0.152.
 */
package org.swixml;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.util.HashMap;
import java.util.Map;
import org.swixml.LayoutConverter;
import org.swixml.layoutconverters.BorderLayoutConverter;
import org.swixml.layoutconverters.CardLayoutConverter;
import org.swixml.layoutconverters.FlowLayoutConverter;
import org.swixml.layoutconverters.GridBagLayoutConverter;
import org.swixml.layoutconverters.GridLayoutConverter;

public class LayoutConverterLibrary {
    private static LayoutConverterLibrary instance = new LayoutConverterLibrary();
    private Map<String, LayoutConverter> layoutConverters = new HashMap<String, LayoutConverter>();
    private Map<String, LayoutConverter> layoutIDs = new HashMap<String, LayoutConverter>();

    private LayoutConverterLibrary() {
        this.registerLayoutConverters();
    }

    public static synchronized LayoutConverterLibrary getInstance() {
        return instance;
    }

    public Map getLayoutConverters() {
        return this.layoutConverters;
    }

    private void registerLayoutConverters() {
        this.register(BorderLayout.class, (LayoutConverter)new BorderLayoutConverter());
        this.register(CardLayout.class, (LayoutConverter)new CardLayoutConverter());
        this.register(FlowLayout.class, (LayoutConverter)new FlowLayoutConverter());
        this.register(GridBagLayout.class, (LayoutConverter)new GridBagLayoutConverter());
        this.register(GridLayout.class, (LayoutConverter)new GridLayoutConverter());
    }

    public void register(Class clazz, LayoutConverter layoutConverter) {
        this.register(clazz.getName(), layoutConverter);
    }

    public void register(String string, LayoutConverter layoutConverter) {
        this.layoutConverters.put(string, layoutConverter);
        this.layoutIDs.put(layoutConverter.getID().toLowerCase(), layoutConverter);
    }

    public LayoutConverter getLayoutConverter(Class clazz) {
        return this.layoutConverters.get(clazz.getName());
    }

    public LayoutConverter getLayoutConverterByID(String string) {
        return this.layoutIDs.get(string.toLowerCase());
    }
}

