/*
 * Decompiled with CFR 0.152.
 */
package org.swixml;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.swixml.ConverterLibrary;
import org.swixml.Factory;
import org.swixml.Setter;
import org.swixml.SetterMethod;

public class DefaultFactory
implements Factory {
    private final List<Setter> setters = new ArrayList<Setter>();
    private final Class template;
    protected Class[] parameterPriority = new Class[]{String.class, Float.TYPE, Double.TYPE, Boolean.TYPE, Character.TYPE, Long.TYPE, Byte.TYPE, Integer.TYPE};

    public DefaultFactory(Class clazz) {
        this.template = clazz;
        this.registerSetters();
    }

    protected int priority(Class clazz) {
        for (int i = 0; i < this.parameterPriority.length; ++i) {
            if (!clazz.isAssignableFrom(this.parameterPriority[i])) continue;
            return i;
        }
        return -1;
    }

    protected void registerSetters() {
        Method[] methodArray = this.template.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            String string = methodArray[i].getName();
            if (!string.startsWith("set") || methodArray[i].getParameterTypes().length != 1) continue;
            Class<?> clazz = methodArray[i].getParameterTypes()[0];
            if (!ConverterLibrary.getInstance().hasConverter(clazz)) continue;
            Setter setter = this.getSetter(string);
            if (setter != null) {
                Class<?> clazz2 = setter.getDeclaringClass();
                Class<?> clazz3 = methodArray[i].getDeclaringClass();
                if (clazz2 == null) continue;
                if (clazz2.equals(clazz3)) {
                    Class<?> clazz4 = setter.getType();
                    if (this.priority(clazz4) >= this.priority(clazz)) continue;
                    this.setters.remove(setter);
                    this.setters.add(new SetterMethod(methodArray[i]));
                    continue;
                }
                if (!clazz2.isAssignableFrom(clazz3)) continue;
                this.setters.remove(setter);
                this.setters.add(new SetterMethod(methodArray[i]));
                continue;
            }
            this.setters.add(new SetterMethod(methodArray[i]));
        }
    }

    @Override
    public Object newInstance(Object object) throws Exception {
        return this.template.newInstance();
    }

    @Override
    public Object newInstance(Object object, Object[] objectArray) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        if (objectArray != null) {
            int n;
            Class[] classArray = new Class[objectArray.length];
            Constructor<?>[] constructorArray = this.template.getConstructors();
            Constructor<?> constructor = null;
            for (n = 0; n < classArray.length; ++n) {
                classArray[n] = objectArray[n].getClass();
            }
            for (n = 0; constructor == null && n < constructorArray.length; ++n) {
                Class<?>[] classArray2 = constructorArray[n].getParameterTypes();
                if (classArray2.length != classArray.length) continue;
                constructor = constructorArray[n];
                for (int i = 0; constructor != null && i < classArray2.length; ++i) {
                    if (classArray2[i].equals(Object.class)) {
                        if (classArray2[i].equals(classArray[i])) continue;
                        constructor = null;
                        continue;
                    }
                    if (classArray2[i].isAssignableFrom(classArray[i])) continue;
                    constructor = null;
                }
            }
            if (constructor != null) {
                return constructor.newInstance(objectArray);
            }
            throw new IllegalArgumentException("unable to find constructor, accepting:" + classArray);
        }
        return this.template.newInstance();
    }

    @Override
    public Class getTemplate() {
        return this.template;
    }

    @Override
    public List<Setter> getSetters() {
        return this.setters;
    }

    @Override
    public Setter getSetter(Class clazz) {
        for (Setter setter : this.setters) {
            if (!setter.getType().equals(clazz)) continue;
            return setter;
        }
        return null;
    }

    @Override
    public Setter getSetter(String string) {
        for (Setter setter : this.setters) {
            if (!setter.getName().equals(string)) continue;
            return setter;
        }
        return null;
    }

    @Override
    public Setter guessSetter(String string) {
        string = ("set" + string).toLowerCase();
        for (Setter setter : this.setters) {
            if (!setter.getName().toLowerCase().equals(string)) continue;
            return setter;
        }
        return null;
    }

    public void removeSetter(Method method) {
        this.setters.remove(method);
    }
}

