/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.tx;

import javax.swing.SwingUtilities;
import net.model3.guice.DependencyInjector;
import net.model3.lang.ClassX;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.logging.SimpleLoggingConfigurator;
import net.model3x.tx.CommandLineTool;

public class ToolRunner {
    protected Logger logger;
    CommandLineTool _commandLineTool;
    private Class<? extends CommandLineTool> _clazz;

    protected ToolRunner() {
    }

    private void setClass(Class<? extends CommandLineTool> clazz) {
        this._clazz = clazz;
    }

    void go() {
        this.logger = this._clazz != null ? LoggerHelper.getLogger(this._clazz) : LoggerHelper.getLogger();
        try {
            this.run();
            this.logger.info((Object)"completed successfully");
            this.doAutoExit(0);
        }
        catch (Exception exception) {
            this.logger.fatal((Object)"fatal error ending program", (Object)exception);
            this.doAutoExit(1);
        }
    }

    void doAutoExit(int n) {
        if (this.autoExit()) {
            System.exit(n);
        }
    }

    boolean autoExit() {
        if (this._commandLineTool == null) {
            return true;
        }
        return this._commandLineTool.autoExit();
    }

    public void run() throws Exception {
        this.logger.debug((Object)"using classloader {}", (Object)Thread.currentThread().getContextClassLoader());
        this.logger.info((Object)"creating an instance of {}", this._clazz);
        this._commandLineTool = (CommandLineTool)DependencyInjector.get().getInstance(this._clazz);
        this.logger.info((Object)"instance created, invoking run() on the instance of {}", this._clazz);
        if (this._commandLineTool.invokeOnEDT()) {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    try {
                        ToolRunner.this.logger.debug((Object)"using classloader {}", (Object)Thread.currentThread().getContextClassLoader());
                        ToolRunner.this._commandLineTool.run();
                    }
                    catch (Exception exception) {
                        ToolRunner.this.logger.fatal((Object)exception);
                    }
                }
            });
        } else {
            this._commandLineTool.run();
        }
    }

    public static void start() {
        new SimpleLoggingConfigurator().addConsoleAppender();
        try {
            Class clazz = ClassX.load((String)new Throwable().getStackTrace()[1].getClassName());
            ToolRunner.startImpl(clazz);
        }
        catch (Exception exception) {
            LoggerHelper.getLogger().error((Object)exception);
            throw new RuntimeException(exception);
        }
    }

    public static void start(Class<? extends CommandLineTool> clazz) {
        new SimpleLoggingConfigurator().addConsoleAppender();
        ToolRunner.startImpl(clazz);
    }

    public static void start(Class<? extends CommandLineTool> clazz, FirstRunner firstRunner) {
        firstRunner.runFirst();
        new SimpleLoggingConfigurator().addConsoleAppender();
        ToolRunner.startImpl(clazz);
    }

    private static void startImpl(Class<? extends CommandLineTool> clazz) {
        try {
            ToolRunner toolRunner = new ToolRunner();
            toolRunner.setClass(clazz);
            toolRunner.go();
        }
        catch (Exception exception) {
            LoggerHelper.getLogger().error((Object)exception);
            throw new RuntimeException(exception);
        }
    }

    public static interface FirstRunner {
        public void runFirst();
    }
}

