/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing.uistate;

import com.google.inject.Inject;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import net.model3.guice.bootstrap.ConfigurationDirectory;
import net.model3.logging.Log;
import net.model3.logging.LogHelper;
import net.model3.newfile.Directory;
import net.model3.newfile.File;
import net.model3.xstream.M3XStreamer;
import net.model3x.swing.uistate.WindowState;

public class FrameStateMarshaller {
    private static final Log logger = LogHelper.getLog();
    private M3XStreamer _xstream = new M3XStreamer();
    Directory _dataDirectory;

    public FrameStateMarshaller(Directory directory) {
        this._dataDirectory = directory;
    }

    @Inject
    public FrameStateMarshaller(ConfigurationDirectory configurationDirectory) {
        this((Directory)configurationDirectory.get());
    }

    public void attach(final Window window) {
        try {
            window.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    try {
                        FrameStateMarshaller.this.saveWindowStateToDisk(window);
                    }
                    catch (Exception exception) {
                        logger.warn((Object)"error saving frame state for {}", (Object)window.getName(), (Object)exception);
                    }
                }
            });
            this.loadWindowStateFromDisk(window);
        }
        catch (Exception exception) {
            logger.warn((Object)"error loading frame state for {}", (Object)window.getName(), (Object)exception);
        }
    }

    public void loadWindowStateFromDisk(Window window) {
        File file = this.getStateFile(window.getName());
        try {
            if (file.exists()) {
                WindowState windowState = (WindowState)this._xstream.fromXML(file.readText());
                windowState.loadComponentTreeFromState(window);
            }
        }
        catch (ClassCastException classCastException) {
            logger.info((Object)"Legacy uistate file found | {}", (Object)window.getName());
        }
        catch (Exception exception) {
            logger.warn((Object)"unable to load from state {}", (Object)file.getCanonicalPath(), (Object)exception);
        }
    }

    public void saveWindowStateToDisk(Window window) {
        WindowState windowState = new WindowState(window);
        File file = this.getStateFile(window.getName());
        file.write(this._xstream.toXML((Object)windowState));
    }

    File getStateFile(String string) {
        File file = new File(this._dataDirectory, "uistate/" + string + ".uistate");
        file.getParent().makeDirectories();
        return file;
    }
}

