/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing.uistate;

import java.awt.Component;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import net.model3.collections.MapX;
import net.model3.lang.StringX;
import net.model3.lang.Visitor;
import net.model3.swing.GuiHelper;
import net.model3x.swing.uistate.SplitPaneState;
import net.model3x.swing.uistate.TableState;

public abstract class ComponentState<T extends Component> {
    public static final String CLIENT_PROPERTY_COMPONENT_NAME_KEY = "uistateName";
    private Map<String, ComponentState<?>> _componentStates = MapX.create();
    private transient ComponentState<?> _currentState;

    public void copyComponentTreeToState(T t) {
        this.updateStateFromComponent(t);
        this._componentStates.clear();
        this._currentState = this;
        GuiHelper.visitDirectDescendantsOnly(t, (Visitor)new Visitor<JComponent>(){

            public void visit(JComponent jComponent) {
                ComponentState componentState = null;
                if (StringX.isNotBlank((String)jComponent.getName())) {
                    if (jComponent instanceof JTable) {
                        componentState = new TableState();
                    } else if (jComponent instanceof JSplitPane) {
                        componentState = new SplitPaneState();
                    }
                }
                ComponentState componentState2 = ComponentState.this._currentState;
                if (componentState != null) {
                    ComponentState.this._currentState.addState(componentState, jComponent);
                    ComponentState.this._currentState = componentState;
                }
                GuiHelper.visitDirectDescendantsOnly((Component)jComponent, (Visitor)this);
                if (componentState != null) {
                    ComponentState.this._currentState = componentState2;
                }
            }
        });
    }

    public void loadComponentTreeFromState(T t) {
        this.updateComponentFromState(t);
        this._currentState = this;
        GuiHelper.visitDirectDescendantsOnly(t, (Visitor)new Visitor<JComponent>(){

            public void visit(JComponent jComponent) {
                ComponentState componentState = (ComponentState)((ComponentState)ComponentState.this._currentState)._componentStates.get(jComponent.getName());
                ComponentState componentState2 = ComponentState.this._currentState;
                if (componentState != null) {
                    componentState.updateComponentFromState(jComponent);
                    ComponentState.this._currentState = componentState;
                }
                GuiHelper.visitDirectDescendantsOnly((Component)jComponent, (Visitor)this);
                if (componentState != null) {
                    ComponentState.this._currentState = componentState2;
                }
            }
        });
    }

    protected abstract void updateStateFromComponent(T var1);

    protected abstract void updateComponentFromState(T var1);

    public static final void setComponentName(JComponent jComponent, String string) {
        jComponent.setName(string);
        jComponent.putClientProperty(CLIENT_PROPERTY_COMPONENT_NAME_KEY, string);
    }

    protected void addState(ComponentState<?> componentState, JComponent jComponent) {
        this._componentStates.put(jComponent.getName(), componentState);
        componentState.updateStateFromComponent(jComponent);
    }
}

