/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing.textfield;

import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import javax.swing.undo.UndoManager;
import net.model3x.swing.textfield.CaseSensitivity;
import net.model3x.swing.textfield.TextAcceptor;

public class TextFieldUtils {
    public static void decorate(JTextComponent jTextComponent, final TextAcceptor textAcceptor, CaseSensitivity caseSensitivity) {
        if (caseSensitivity == null) {
            caseSensitivity = CaseSensitivity.Insensitve;
        }
        final CaseSensitivity caseSensitivity2 = caseSensitivity;
        jTextComponent.setDocument(new PlainDocument(){
            private static final long serialVersionUID = 1L;

            @Override
            public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
                if ((string = caseSensitivity2.translate(string)).length() == 1) {
                    if (textAcceptor.accept(string.charAt(0))) {
                        super.insertString(n, string, attributeSet);
                    }
                } else if (string.length() > 1) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (int i = 0; i < string.length(); ++i) {
                        char c = string.charAt(i);
                        if (!textAcceptor.accept(c)) continue;
                        stringBuilder.append(c);
                    }
                    super.insertString(n, stringBuilder.toString(), attributeSet);
                }
            }
        });
    }

    public static void addUndoableFunctionality(JTextComponent jTextComponent) {
        final UndoManager undoManager = new UndoManager();
        jTextComponent.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 90 && keyEvent.isControlDown()) {
                    if (undoManager.canUndo()) {
                        undoManager.undo();
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                    }
                } else if (keyEvent.getKeyCode() == 89 && keyEvent.isControlDown()) {
                    if (undoManager.canRedo()) {
                        undoManager.redo();
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                    }
                }
            }
        });
        jTextComponent.getDocument().addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
                undoManager.addEdit(undoableEditEvent.getEdit());
            }
        });
    }
}

