/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing.table;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import net.model3.collections.SetX;
import net.model3.logging.Log;
import net.model3.logging.LogHelper;
import net.model3.swing.GuiHelper;
import net.model3x.swing.ColumnHandler;
import net.model3x.swing.IBeanTableModel;
import net.model3x.swing.table.AdvancedPopup;
import net.model3x.swing.table.FilterPopup;
import net.model3x.swing.table.SortableFilterableHeaderRender;
import net.model3x.swing.table.TableModelColumnHelper;

public class TableUtil {
    private static final Log logger = LogHelper.getLog(TableUtil.class);

    public static <T> void addPopupsToTable(final TableModelColumnHelper tableModelColumnHelper, final IBeanTableModel<T> iBeanTableModel, boolean bl) {
        iBeanTableModel.setIgnoreToggleSortOrder(true);
        tableModelColumnHelper.getTableHeader().setDefaultRenderer(new SortableFilterableHeaderRender(iBeanTableModel));
        TableUtil.configureEnclosingScrollPane(tableModelColumnHelper, bl);
        tableModelColumnHelper.getTableImpl().getTableHeader().setDefaultRenderer(new SortableFilterableHeaderRender(iBeanTableModel));
        tableModelColumnHelper.getTableImpl().getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                logger.debug((Object)mouseEvent);
                int n = tableModelColumnHelper.getTableImpl().convertColumnIndexToModel(tableModelColumnHelper.getTableImpl().getTableHeader().columnAtPoint(mouseEvent.getPoint()));
                ColumnHandler columnHandler = iBeanTableModel.getColumn(n);
                Set set = SetX.create();
                for (Object TRow : iBeanTableModel.getRows()) {
                    set.add(columnHandler.getColumnValue(TRow, n));
                }
                FilterPopup filterPopup = new FilterPopup(tableModelColumnHelper, mouseEvent.getLocationOnScreen(), columnHandler, set);
                filterPopup.toString();
            }
        });
    }

    private static void configureEnclosingScrollPane(final TableModelColumnHelper tableModelColumnHelper, boolean bl) {
        tableModelColumnHelper.getTableHeaderContainer().removeAll();
        Container container = tableModelColumnHelper.getParent();
        if (container instanceof JViewport) {
            Container container2 = container.getParent();
            if (container2 instanceof JScrollPane) {
                JComponent jComponent;
                JScrollPane jScrollPane = (JScrollPane)container2;
                if (bl) {
                    jScrollPane.setVerticalScrollBarPolicy(22);
                    jComponent = new JButton("...");
                    ((AbstractButton)jComponent).addActionListener(new ActionListener((JButton)jComponent){
                        private static final long serialVersionUID = 1L;
                        final /* synthetic */ JButton val$button;
                        {
                            this.val$button = jButton;
                        }

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            new AdvancedPopup(tableModelColumnHelper, this.val$button.getLocationOnScreen()).toString();
                        }
                    });
                    jScrollPane.setCorner("UPPER_RIGHT_CORNER", jComponent);
                }
                if ((jComponent = jScrollPane.getViewport()) != null && ((JViewport)jComponent).getView() == tableModelColumnHelper) {
                    Border border;
                    tableModelColumnHelper.getTableHeaderContainer().setVisible(false);
                    jScrollPane.setColumnHeaderView(tableModelColumnHelper.getTableHeader());
                    Border border2 = jScrollPane.getBorder();
                    if ((border2 == null || border2 instanceof UIResource) && (border = UIManager.getBorder("Table.scrollPaneBorder")) != null) {
                        jScrollPane.setBorder(border);
                    }
                }
            }
        } else {
            tableModelColumnHelper.getTableHeaderContainer().setVisible(true);
            tableModelColumnHelper.getTableHeaderContainer().add(tableModelColumnHelper.getTableHeader());
        }
        GuiHelper.doLayoutHack((Component)tableModelColumnHelper.getTableHeaderContainer());
    }
}

