/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing.table;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import net.model3x.swing.IBeanTableModel;
import net.model3x.swing.M3Panel;

public class SortableFilterableHeaderRender
extends JPanel
implements TableCellRenderer {
    private JLabel title;
    private JLabel order;
    private JLabel filter;
    private JLabel number;
    private StringIcon filterIcon;
    private Icon ascIcon;
    private Icon descIcon;
    private IBeanTableModel tableModel;

    public SortableFilterableHeaderRender(IBeanTableModel iBeanTableModel) {
        this.tableModel = iBeanTableModel;
        this.title = new JLabel();
        this.order = new JLabel();
        this.filter = new JLabel();
        this.number = new JLabel();
        this.ascIcon = UIManager.getIcon("Table.ascendingSortIcon");
        if (this.ascIcon == null) {
            this.ascIcon = new StringIcon("\u25b2");
        }
        this.descIcon = UIManager.getIcon("Table.descendingSortIcon");
        if (this.descIcon == null) {
            this.descIcon = new StringIcon("\u25bc");
        }
        this.filterIcon = new StringIcon("*");
        this.setLayout(new BorderLayout());
        M3Panel m3Panel = new M3Panel();
        m3Panel.add((Component)this.title);
        m3Panel.add((Component)this.filter);
        m3Panel.add((Component)this.order);
        m3Panel.add((Component)this.number);
        this.add((Component)m3Panel, "Center");
        this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Object object2;
        this.title.setText(object.toString());
        boolean bl3 = false;
        RowSorter<? extends TableModel> rowSorter = jTable.getRowSorter();
        int n3 = jTable.convertColumnIndexToModel(n2);
        try {
            if (this.tableModel.getColumnCount() > 0 && (object2 = this.tableModel.getColumn(n3)).getFilter().isActive()) {
                this.filter.setIcon(this.filterIcon);
                bl3 = true;
            }
            if (!bl3) {
                this.filter.setIcon(null);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            System.out.println(indexOutOfBoundsException.getMessage());
        }
        bl3 = false;
        if (rowSorter != null && !(object2 = rowSorter.getSortKeys()).isEmpty()) {
            int n4 = 0;
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                Icon icon;
                RowSorter.SortKey sortKey = (RowSorter.SortKey)iterator.next();
                ++n4;
                if (sortKey.getColumn() != n3) continue;
                SortOrder sortOrder = sortKey.getSortOrder();
                Icon icon2 = icon = sortOrder == SortOrder.ASCENDING ? this.ascIcon : this.descIcon;
                if (object2.size() > 1) {
                    this.number.setText("" + n4++);
                } else {
                    this.number.setText("");
                }
                this.order.setIcon(icon);
                bl3 = true;
                break;
            }
        }
        if (!bl3) {
            this.order.setIcon(null);
            this.number.setText("");
        }
        return this;
    }

    class StringIcon
    implements Icon {
        private String string;

        public StringIcon(String string) {
            this.string = string;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.drawString(this.string, n, n2 + 10);
        }

        @Override
        public int getIconWidth() {
            return 12;
        }

        @Override
        public int getIconHeight() {
            return 12;
        }
    }
}

