/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing.table;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JTextField;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.model3.collections.ListX;
import net.model3.collections.MapX;
import net.model3.collections.SetX;
import net.model3.lang.StringX;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3x.swing.ColumnHandler;
import net.model3x.swing.live.LiveTable;
import net.model3x.swing.popup.AbstractPopup;
import net.model3x.swing.table.TableModelColumnHelper;

public class FilterPopup
extends AbstractPopup {
    static final Logger logger = LoggerHelper.getLogger();
    final Set<Object> _selectedChoices;
    final Set<Object> _allChoices;
    final ColumnHandler _column;
    final Map<Object, JCheckBox> _choicesToCheckboxes = MapX.create();
    final TableModelColumnHelper _table;
    final JTextField _searchField = new JTextField(20);
    JCheckBox _selectAll;

    public FilterPopup(TableModelColumnHelper tableModelColumnHelper, Point point, ColumnHandler columnHandler, Set<Object> set) {
        super(tableModelColumnHelper.getTableImpl(), point);
        this._table = tableModelColumnHelper;
        this._allChoices = set;
        if (columnHandler.getFilter().getSelectedValues() == null) {
            columnHandler.getFilter().setSelectedValues(SetX.create(this._allChoices));
        }
        this._selectedChoices = columnHandler.getFilter().getSelectedValues();
        this._column = columnHandler;
        this.initView();
    }

    @Override
    protected void addComponentsToPanel() {
        this._searchField.setName("SearchField");
        this.addItem("Sort Ascending A-Z", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                logger.debug((Object)"sort ascending");
                FilterPopup.this.setSort(SortOrder.ASCENDING);
                FilterPopup.this.close();
            }
        });
        this.addItem("Sort Descending Z-A", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                logger.debug((Object)"sort descending");
                FilterPopup.this.setSort(SortOrder.DESCENDING);
                FilterPopup.this.close();
            }
        });
        this.addItem("Clear Filter", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                logger.debug((Object)"clear filter");
                FilterPopup.this.clearFilter();
            }
        });
        this._searchField.setText(this._column.getFilter().getSearchText());
        this._searchField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                FilterPopup.this.updateSearchText();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                FilterPopup.this.updateSearchText();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                FilterPopup.this.updateSearchText();
            }
        });
        this._panel.add((Component)this._searchField, (Object)"wrap");
        this._panel.add((Component)this.createSelectAllCB(), (Object)"wrap");
        List list = ListX.create(this._allChoices);
        Comparator<Object> comparator = new Comparator<Object>(){

            @Override
            public int compare(Object object, Object object2) {
                return object.toString().compareTo(object2.toString());
            }
        };
        Collections.sort(list, comparator);
        for (Object e : list) {
            if (e == null) continue;
            final Object e2 = e;
            final JCheckBox jCheckBox = new JCheckBox(e.toString());
            jCheckBox.setName(e.toString());
            jCheckBox.setFocusable(true);
            jCheckBox.setSelected(this._selectedChoices.contains(e));
            this._panel.add((Component)jCheckBox, (Object)"wrap");
            this._choicesToCheckboxes.put(e, jCheckBox);
            jCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    jCheckBox.requestFocusInWindow();
                    if (jCheckBox.isSelected()) {
                        FilterPopup.this._selectedChoices.add(e2);
                    } else {
                        FilterPopup.this._selectedChoices.remove(e2);
                    }
                    FilterPopup.this.refilterTable();
                }
            });
        }
    }

    void setSort(SortOrder sortOrder) {
        int n = this._table.columnIndex(this._column);
        if (this._table instanceof LiveTable) {
            LiveTable liveTable = (LiveTable)((Object)this._table);
            liveTable.getModel().getSortabledList().setComparator(liveTable.getModel().getTableFormat().getColumnComparator(n));
        } else {
            List list = ListX.create((Object[])new RowSorter.SortKey[]{new RowSorter.SortKey(n, sortOrder)});
            this._table.getModel().getRowSorter().setSortKeys(list);
        }
    }

    protected final JCheckBox createSelectAllCB() {
        String string = "Select All";
        if (StringX.isNotBlank((String)this._column.getFilter().getSearchText())) {
            string = string + "*";
        }
        this._selectAll = new JCheckBox(string);
        this._selectAll.setName("SelectAll");
        this._selectAll.setSelected(this._selectedChoices.containsAll(this._allChoices));
        this._selectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FilterPopup.this._selectAll.requestFocusInWindow();
                if (FilterPopup.this._selectAll.isSelected()) {
                    FilterPopup.this._selectedChoices.addAll(FilterPopup.this._allChoices);
                } else {
                    FilterPopup.this._selectedChoices.clear();
                }
                for (JCheckBox jCheckBox : FilterPopup.this._choicesToCheckboxes.values()) {
                    jCheckBox.setSelected(FilterPopup.this._selectAll.isSelected());
                }
                FilterPopup.this.refilterTable();
            }
        });
        return this._selectAll;
    }

    private void updateSearchText() {
        this._column.getFilter().setSearchText(this._searchField.getText());
        this.refilterTable();
    }

    void clearFilter() {
        logger.debug((Object)"clearing filter");
        this._selectAll.setSelected(true);
        this._selectedChoices.addAll(this._allChoices);
        this._searchField.setText("");
        for (JCheckBox jCheckBox : this._choicesToCheckboxes.values()) {
            jCheckBox.setSelected(true);
        }
        this.refilterTable();
    }

    void refilterTable() {
        boolean bl = false;
        boolean bl2 = StringX.isBlank((String)this._column.getFilter().getSearchText());
        if (this._selectedChoices.isEmpty() || !this._selectedChoices.containsAll(this._allChoices)) {
            this._selectAll.setSelected(false);
            bl = true;
        } else {
            this._selectAll.setSelected(true);
            if (!bl2) {
                bl = true;
            }
        }
        if (bl2) {
            this._selectAll.setText("Select All");
        } else {
            this._selectAll.setText("Select All*");
        }
        this._table.getModel().getRowSorter().sort();
        this._column.getFilter().setActive(bl);
        this._table.getTableHeader().repaint();
    }
}

