/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing.table;

import ca.odell.glazedlists.matchers.AbstractMatcherEditor;
import ca.odell.glazedlists.matchers.Matcher;
import java.util.Set;
import net.model3.lang.StringX;
import net.model3.logging.Log;
import net.model3.logging.LogHelper;
import net.model3x.swing.ColumnHandler;

public class ColumnFilter<T>
extends AbstractMatcherEditor<T> {
    private static final Log logger = LogHelper.getLog(ColumnFilter.class);
    String _searchText = "";
    String _searchTextLowerCase = "";
    Set<Object> _selectedValues;
    boolean _active = false;
    ColumnHandler<T> _column;

    public ColumnFilter(ColumnHandler<T> columnHandler) {
        this.currentMatcher = new Matcher<T>(){

            public boolean matches(T t) {
                Object object = ColumnFilter.this._column.getColumnValue(t, -1);
                return ColumnFilter.this.include(object);
            }
        };
        this._column = columnHandler;
    }

    public void refilter() {
        this.fireChanged(this.currentMatcher);
    }

    public boolean include(Object object) {
        boolean bl;
        if (!this._active) {
            return true;
        }
        if (object == null) {
            return true;
        }
        if (StringX.isBlank((String)object.toString())) {
            if (!(object instanceof String)) {
                logger.warn((Object)"toString is null, but column value is not null", (Object)new RuntimeException());
            }
            return true;
        }
        boolean bl2 = bl = this._selectedValues == null || this._selectedValues.contains(object);
        if (bl) {
            boolean bl3 = object.toString().toLowerCase().contains(this._searchTextLowerCase);
            return bl3;
        }
        return false;
    }

    public boolean isActive() {
        return this._active;
    }

    public void setActive(boolean bl) {
        this._active = bl;
    }

    public void setSearchText(String string) {
        this._searchText = string;
        this._searchTextLowerCase = this._searchText.toLowerCase();
    }

    public String getSearchText() {
        return this._searchText;
    }

    public void setSelectedValues(Set<Object> set) {
        this._selectedValues = set;
    }

    public Set<Object> getSelectedValues() {
        return this._selectedValues;
    }
}

