/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing.table;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import net.model3.collections.ListX;
import net.model3.collections.MapX;
import net.model3.lang.StringX;
import net.model3x.swing.EntityComboBoxModel;
import net.model3x.swing.M3Panel;

public class AdvancedSorter
extends JDialog {
    private static final long serialVersionUID = -3495239622146054396L;
    private final JTable _table;
    private Map<String, Integer> columnMap;
    private List<SortRow> sortRows = ListX.create();
    private M3Panel _root;
    private M3Panel _rows;

    public AdvancedSorter(Window window, JTable jTable) {
        super(window, Dialog.ModalityType.APPLICATION_MODAL);
        this._table = jTable;
        this.init();
    }

    private void init() {
        List<RowSorter.SortKey> list = this._table.getRowSorter().getSortKeys();
        this.columnMap = MapX.create();
        for (int i = 0; i < this._table.getColumnCount(); ++i) {
            this.columnMap.put(this._table.getColumnName(i), i);
        }
        this._root = new M3Panel("fill");
        this._rows = new M3Panel("fill");
        for (RowSorter.SortKey sortKey : list) {
            this.addRow(sortKey);
        }
        this.addRow();
        this._root.add((Component)this._rows, (Object)"grow, wrap");
        JButton jButton = new JButton(new AbstractAction("Done"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AdvancedSorter.this.setVisible(false);
            }
        });
        this._root.add((Component)jButton, (Object)"span, align center");
        this.add((Component)this._root);
        this.pack();
    }

    void applySortOrder() {
        List list = ListX.create();
        for (SortRow sortRow : this.sortRows) {
            if (!sortRow.isComplete()) continue;
            list.add(sortRow.getSortKey());
        }
        this._table.getRowSorter().setSortKeys(list);
    }

    private SortRow addRow() {
        SortRow sortRow = new SortRow();
        this._rows.add((Component)sortRow.getRow(), (Object)"growx, wrap");
        this.sortRows.add(sortRow);
        this.pack();
        return sortRow;
    }

    private SortRow addRow(RowSorter.SortKey sortKey) {
        SortRow sortRow = new SortRow(sortKey);
        this._rows.add((Component)sortRow.getRow(), (Object)"growx, wrap");
        this.sortRows.add(sortRow);
        this.pack();
        return sortRow;
    }

    class SortRow {
        M3Panel _panel;
        JComboBox _columnNameBox;
        JComboBox _sortOrderBox;
        EntityComboBoxModel<String> _columnModel;
        EntityComboBoxModel<SortOrder> _sortModel;
        boolean _lastRowInserted = false;
        JButton _removeRowButton = new JButton("X");
        boolean _removed = false;

        SortRow() {
            this.init(null, null);
        }

        SortRow(RowSorter.SortKey sortKey) {
            int n = sortKey.getColumn();
            String string = AdvancedSorter.this._table.getColumnName(n);
            this.init(string, sortKey.getSortOrder());
        }

        void init(String string, SortOrder sortOrder) {
            this._panel = new M3Panel("fillx");
            this._panel.add((Component)new JLabel("Sort by"));
            this._columnModel = new EntityComboBoxModel(AdvancedSorter.this.columnMap.keySet());
            this._columnNameBox = new JComboBox<String>(this._columnModel);
            this._panel.add((Component)this._columnNameBox);
            this._sortModel = new EntityComboBoxModel(ListX.create((Object[])new SortOrder[]{SortOrder.ASCENDING, SortOrder.DESCENDING}));
            this._sortModel.setSelectedEntity(SortOrder.ASCENDING);
            this._sortOrderBox = new JComboBox<SortOrder>(this._sortModel);
            this._panel.add((Component)this._sortOrderBox);
            if (StringX.isNotBlank((String)string)) {
                this._columnModel.setSelectedEntity(string);
                this._sortModel.setSelectedEntity(sortOrder);
            }
            if (this.isComplete()) {
                this._lastRowInserted = true;
            }
            this._panel.add((Component)this._removeRowButton);
            this._removeRowButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (SortRow.this._panel.getParent() != null && !SortRow.this._removed) {
                        SortRow.this._panel.getParent().remove((Component)SortRow.this._panel);
                        SortRow.this._removed = true;
                    }
                }
            });
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (!SortRow.this._lastRowInserted && SortRow.this.isComplete()) {
                        AdvancedSorter.this.addRow();
                    }
                }
            };
            this._columnNameBox.addActionListener(actionListener);
            this._sortOrderBox.addActionListener(actionListener);
        }

        boolean isComplete() {
            return !this._removed && this._columnModel.getSelectedEntity() != null && this._sortModel.getSelectedEntity() != null;
        }

        M3Panel getRow() {
            return this._panel;
        }

        RowSorter.SortKey getSortKey() {
            int n = (Integer)AdvancedSorter.this.columnMap.get(this._columnModel.getSelectedEntity());
            n = AdvancedSorter.this._table.convertColumnIndexToModel(n);
            SortOrder sortOrder = this._sortModel.getSelectedEntity();
            return new RowSorter.SortKey(n, sortOrder);
        }
    }
}

