/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing.popup;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import net.model3.logging.Log;
import net.model3.logging.LogHelper;

public class MouseSpyPanel
extends JComponent {
    private static final long serialVersionUID = 6335852483427668102L;
    private static final Log logger = LogHelper.getLog(MouseSpyPanel.class);
    private boolean traceMouse = false;

    public MouseSpyPanel() {
        this(false);
    }

    public MouseSpyPanel(boolean bl) {
        this.addMouseListener(new MouseAdapter(){});
        this.addMouseMotionListener(new MouseAdapter(){});
        this.traceMouse = bl;
    }

    @Override
    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof MouseEvent) {
            this.redispatchMouseEvent((MouseEvent)aWTEvent);
        } else {
            super.processEvent(aWTEvent);
        }
    }

    protected void spiedMouseEvent(MouseEvent mouseEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void redispatchMouseEvent(MouseEvent mouseEvent) {
        if (this.traceMouse && mouseEvent.getID() == 503) {
            logger.debug((Object)"{} | {}", (Object)mouseEvent.getLocationOnScreen(), (Object)mouseEvent.getPoint());
        }
        JRootPane jRootPane = SwingUtilities.getRootPane(this);
        Point point = mouseEvent.getLocationOnScreen();
        this.spiedMouseEvent(mouseEvent);
        this.setVisible(false);
        try {
            int n = point.x - jRootPane.getLocationOnScreen().x;
            int n2 = point.y - jRootPane.getLocationOnScreen().y;
            Component component = SwingUtilities.getDeepestComponentAt(jRootPane, n, n2);
            if (component != null) {
                Point point2 = new Point();
                point2.x = point.x - component.getLocationOnScreen().x;
                point2.y = point.y - component.getLocationOnScreen().y;
                component.dispatchEvent(new MouseEvent(component, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point2.x, point2.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger()));
            }
        }
        finally {
            this.setVisible(true);
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        JPanel jPanel = new JPanel();
        jFrame.getContentPane().setLayout(new FlowLayout());
        jFrame.getContentPane().add(jPanel);
        jPanel.add(new JButton("hello"));
        JTextField jTextField = new JTextField(15);
        jPanel.add(jTextField);
        jTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                System.out.println(keyEvent);
            }
        });
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        MouseSpyPanel mouseSpyPanel = new MouseSpyPanel();
        jFrame.getLayeredPane().add((Component)mouseSpyPanel, JLayeredPane.DRAG_LAYER);
        mouseSpyPanel.setBounds(0, 0, 2000, 2000);
        jFrame.setVisible(true);
    }
}

