/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing.popup;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.swing.GuiHelper;
import net.model3x.swing.M3Panel;
import net.model3x.swing.popup.HoverMouseAdapter;
import net.model3x.swing.popup.MouseSpyPanel;

public abstract class AbstractPopup {
    private static final Logger logger = LoggerHelper.getLogger(AbstractPopup.class);
    protected final JComponent _referenceComponent;
    protected final Point _locationOnScreen;
    protected final JLayeredPane _layeredPane;
    protected final JScrollPane _scrollPane;
    protected final M3Panel _panel = new M3Panel("insets 4, fill");
    protected final MouseSpyPanel _mouseSpyPanel;

    public AbstractPopup(JComponent jComponent, Point point) {
        this._referenceComponent = jComponent;
        this._locationOnScreen = point;
        this._layeredPane = SwingUtilities.getRootPane(this._referenceComponent).getLayeredPane();
        this._scrollPane = new JScrollPane((Component)this._panel);
        this._mouseSpyPanel = new MouseSpyPanel(false){

            @Override
            protected void spiedMouseEvent(MouseEvent mouseEvent) {
                if (mouseEvent.getID() == 501) {
                    AbstractPopup.this.close();
                }
            }
        };
    }

    protected void initView() {
        Point point = new Point();
        Point point2 = this._layeredPane.getLocationOnScreen();
        point.x = this._locationOnScreen.x - point2.x;
        point.y = this._locationOnScreen.y - point2.y;
        this._scrollPane.setName("ScrollPane");
        this._panel.setName("RootPanel");
        this.addComponentsToPanel();
        Dimension dimension = this._panel.getPreferredSize();
        int n = this._layeredPane.getHeight() - point.y;
        dimension.height = Math.min(dimension.height, n) + 5;
        dimension.width += 30;
        this._layeredPane.add((Component)this._mouseSpyPanel, new Integer(this._layeredPane.highestLayer() + 1));
        this._mouseSpyPanel.setSize(this._layeredPane.getSize());
        this._mouseSpyPanel.setLocation(0, 0);
        this._scrollPane.setSize(dimension);
        this._scrollPane.setLocation(point);
        this._layeredPane.add((Component)this._scrollPane, new Integer(this._layeredPane.highestLayer() + 1));
        this.makePanelFullyVisibleInWindow();
        this._panel.requestFocus();
    }

    protected abstract void addComponentsToPanel();

    protected void addItem(String string, ActionListener actionListener) {
        JLabel jLabel = new JLabel(string);
        jLabel.setName(string);
        jLabel.setOpaque(true);
        this._panel.add((Component)jLabel, (Object)"growx, wrap");
        jLabel.addMouseListener(new HoverMouseAdapter(jLabel, actionListener));
    }

    protected void addSeparator() {
        JSeparator jSeparator = new JSeparator();
        jSeparator.setName("separator");
        this._panel.add((Component)jSeparator, (Object)"wrap");
    }

    protected void close() {
        logger.debug((Object)"closing window");
        this._layeredPane.remove(this._mouseSpyPanel);
        this._layeredPane.remove(this._scrollPane);
        GuiHelper.doLayoutHack((Component)this._layeredPane);
    }

    private void makePanelFullyVisibleInWindow() {
        Dimension dimension = this._scrollPane.getSize();
        Point point = this._scrollPane.getLocation();
        Window window = SwingUtilities.getWindowAncestor(this._referenceComponent);
        Dimension dimension2 = window.getSize();
        if (dimension2.width <= point.x + dimension.width + this._scrollPane.getVerticalScrollBar().getWidth()) {
            point.x = dimension2.width - dimension.width - this._scrollPane.getVerticalScrollBar().getWidth();
            this._scrollPane.setLocation(point);
        }
        int n = this._layeredPane.getHeight() - point.y - 10;
        dimension.height = Math.min(n, dimension.height);
        this._scrollPane.setSize(dimension);
    }
}

