/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing.mbus;

import com.google.common.collect.MapMaker;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.lang.ref.SoftReference;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.model3.collections.ListX;
import net.model3.guice.DependencyInjector;
import net.model3.lang.ClassX;
import net.model3.lang.ThreadScheduler;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3x.swing.mbus.AttachmentPoint;
import net.model3x.swing.mbus.AttachmentPointInstance;
import net.model3x.swing.mbus.MBusAttach;
import net.model3x.swing.mbus.MessageBus;

@Singleton
public class MessageBusImpl
implements MessageBus {
    Logger logger = LoggerHelper.getLogger();
    Map<Class<?>, Object> _valuesMap = new MapMaker().concurrencyLevel(4).makeMap();
    Map<Class<?>, List<AttachmentPointInstance>> _listenersMap = new MapMaker().concurrencyLevel(4).makeMap();
    Map<Class<?>, List<AttachmentPoint>> _attachmentPointsMap = new MapMaker().concurrencyLevel(4).makeMap();
    @Inject
    ThreadScheduler _threadScheduler;

    @Override
    public void fireBean(Object object, Object object2) {
        this.fireBean(object, object2.getClass(), object2);
    }

    @Override
    public void fireBean(Object object, Class<?> clazz, Object object2) {
        if (object2 == null) {
            return;
        }
        this._valuesMap.put(object2.getClass(), object2);
        Iterator<AttachmentPointInstance> iterator = this.getListeners(clazz).iterator();
        while (iterator.hasNext()) {
            AttachmentPointInstance attachmentPointInstance = iterator.next();
            Object object3 = attachmentPointInstance._reference.get();
            if (object3 == null) {
                iterator.remove();
                continue;
            }
            if (object3 == object) continue;
            attachmentPointInstance.invoke(object2);
        }
    }

    @Override
    public Object attach(Object object) {
        for (AttachmentPoint attachmentPoint : this.getAttachmentPoints(object.getClass())) {
            AttachmentPointInstance attachmentPointInstance = new AttachmentPointInstance();
            attachmentPointInstance._attachmentPoint = attachmentPoint;
            attachmentPointInstance._reference = new SoftReference<Object>(object);
            Class<?> clazz = attachmentPoint.getType();
            this.getListeners(attachmentPointInstance._attachmentPoint.getType()).add(attachmentPointInstance);
            Object object2 = this._valuesMap.get(clazz);
            if (object2 == null) continue;
            attachmentPointInstance.invoke(object2);
        }
        return object;
    }

    List<AttachmentPoint> getAttachmentPoints(Class<?> clazz) {
        List list = this._attachmentPointsMap.get(clazz);
        if (list == null) {
            AttachmentPoint attachmentPoint;
            MBusAttach mBusAttach;
            list = ListX.create();
            for (AccessibleObject accessibleObject : ClassX.getMethods(clazz)) {
                mBusAttach = ((Method)accessibleObject).getAnnotation(MBusAttach.class);
                if (mBusAttach == null) continue;
                if (((Method)accessibleObject).getParameterTypes().length != 1) {
                    this.logger.warn((Object)"MBusAttach method {} not a single parm method", (Object)accessibleObject);
                    continue;
                }
                ((Method)accessibleObject).setAccessible(true);
                attachmentPoint = new AttachmentPoint(this);
                attachmentPoint._mBusAttach = mBusAttach;
                attachmentPoint._method = accessibleObject;
                list.add(attachmentPoint);
            }
            for (AccessibleObject accessibleObject : ClassX.getFields(clazz)) {
                mBusAttach = ((Field)accessibleObject).getAnnotation(MBusAttach.class);
                if (mBusAttach == null) continue;
                ((Field)accessibleObject).setAccessible(true);
                attachmentPoint = new AttachmentPoint(this);
                attachmentPoint._mBusAttach = mBusAttach;
                attachmentPoint._field = accessibleObject;
                list.add(attachmentPoint);
            }
            this._attachmentPointsMap.put(clazz, list);
        }
        return list;
    }

    @Override
    public <T> T getCurrentBean(Class<T> clazz) {
        return (T)this._valuesMap.get(clazz);
    }

    List<AttachmentPointInstance> getListeners(Class<?> clazz) {
        if (!this._listenersMap.containsKey(clazz)) {
            this._listenersMap.put(clazz, new ArrayList());
        }
        return this._listenersMap.get(clazz);
    }

    ThreadScheduler getThreadScheduler() {
        if (this._threadScheduler == null) {
            this._threadScheduler = (ThreadScheduler)DependencyInjector.getInstance(ThreadScheduler.class);
        }
        return this._threadScheduler;
    }
}

