/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing.mbus;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.swing.SwingUtilities;
import net.model3x.swing.mbus.MBusAttach;
import net.model3x.swing.mbus.MessageBusImpl;

class AttachmentPoint {
    private final MessageBusImpl _messageBusImpl;
    Method _method;
    Field _field;
    MBusAttach _mBusAttach;

    AttachmentPoint(MessageBusImpl messageBusImpl) {
        this._messageBusImpl = messageBusImpl;
    }

    Class<?> getType() {
        if (this._method != null) {
            return this._method.getParameterTypes()[0];
        }
        return this._field.getType();
    }

    void invoke(final Object object, final Object object2) {
        if (object != null) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        if (AttachmentPoint.this._method != null) {
                            AttachmentPoint.this._method.invoke(object, object2);
                        }
                        if (AttachmentPoint.this._field != null) {
                            AttachmentPoint.this._field.set(object, object2);
                        }
                    }
                    catch (Exception exception) {
                        ((AttachmentPoint)AttachmentPoint.this)._messageBusImpl.logger.warn((Object)"error firing bean {}", object, (Object)exception);
                    }
                }
            };
            boolean bl = SwingUtilities.isEventDispatchThread();
            if (this._mBusAttach.avoidEDT()) {
                if (bl) {
                    this._messageBusImpl.getThreadScheduler().submit("mbus", runnable);
                } else {
                    runnable.run();
                }
            } else if (this._mBusAttach.useEDT()) {
                if (bl) {
                    runnable.run();
                } else {
                    SwingUtilities.invokeLater(runnable);
                }
            } else {
                runnable.run();
            }
        }
    }
}

