/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing.live;

import ca.odell.glazedlists.matchers.AbstractMatcherEditor;
import ca.odell.glazedlists.matchers.Matcher;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.model3x.swing.live.LiveTableModel;

public class TextFieldFilter<T>
extends AbstractMatcherEditor<T> {
    LiveTableModel<T> _model;
    JTextField _textField;
    String _filterText = "";

    public TextFieldFilter(LiveTableModel<T> liveTableModel, JTextField jTextField) {
        this.currentMatcher = new Matcher<T>(){

            public boolean matches(T t) {
                if (TextFieldFilter.this._filterText.length() == 0) {
                    return true;
                }
                int n = TextFieldFilter.this._model.getColumnCount();
                for (int i = 0; i < n; ++i) {
                    Object object = TextFieldFilter.this._model.getTableFormat().getColumnValue(t, i);
                    if (object == null || !object.toString().toLowerCase().contains(TextFieldFilter.this._filterText)) continue;
                    return true;
                }
                return false;
            }
        };
        this._model = liveTableModel;
        this._textField = jTextField;
        this._textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                TextFieldFilter.this.refilter();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                TextFieldFilter.this.refilter();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                TextFieldFilter.this.refilter();
            }
        });
        this._model.getFilters().add((Object)this);
    }

    public void refilter() {
        this._filterText = this._textField.getText().trim().toLowerCase();
        this.fireChanged(this.currentMatcher);
    }
}

