/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing.live;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import net.model3x.swing.ColumnHandler;
import net.model3x.swing.M3Panel;
import net.model3x.swing.live.LiveTableModel;

public class SortableFilterableHeaderRender
extends JPanel
implements TableCellRenderer {
    JLabel _title;
    JLabel _order;
    JLabel _filter;
    JLabel _number;
    StringIcon _filterIcon;
    Icon _ascIcon;
    Icon _descIcon;
    LiveTableModel<?> _tableModel;

    public SortableFilterableHeaderRender(LiveTableModel<?> liveTableModel) {
        this._tableModel = liveTableModel;
        this._title = new JLabel();
        this._order = new JLabel();
        this._filter = new JLabel();
        this._number = new JLabel();
        this._ascIcon = UIManager.getIcon("Table.ascendingSortIcon");
        if (this._ascIcon == null) {
            this._ascIcon = new StringIcon("\u25b2");
        }
        this._descIcon = UIManager.getIcon("Table.descendingSortIcon");
        if (this._descIcon == null) {
            this._descIcon = new StringIcon("\u25bc");
        }
        this._filterIcon = new StringIcon("*");
        this.setLayout(new BorderLayout());
        M3Panel m3Panel = new M3Panel();
        m3Panel.add((Component)this._title);
        m3Panel.add((Component)this._filter);
        m3Panel.add((Component)this._order);
        m3Panel.add((Component)this._number);
        this.add((Component)m3Panel, "Center");
        this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this._title.setText(object.toString());
        boolean bl3 = false;
        int n3 = jTable.convertColumnIndexToModel(n2);
        try {
            ColumnHandler<?> columnHandler;
            if (this._tableModel.getColumnCount() > 0 && (columnHandler = this._tableModel.getColumn(n3)).getFilter().isActive()) {
                this._filter.setIcon(this._filterIcon);
                bl3 = true;
            }
            if (!bl3) {
                this._filter.setIcon(null);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            System.out.println(indexOutOfBoundsException.getMessage());
        }
        bl3 = false;
        for (int i = 0; i < this._tableModel.getSortKeys().size(); ++i) {
            Icon icon;
            RowSorter.SortKey sortKey = this._tableModel.getSortKeys().get(i);
            if (sortKey.getColumn() != n2) continue;
            SortOrder sortOrder = sortKey.getSortOrder();
            Icon icon2 = icon = sortOrder == SortOrder.ASCENDING ? this._ascIcon : this._descIcon;
            if (this._tableModel.getSortKeys().size() > 1) {
                this._number.setText("" + i++);
            } else {
                this._number.setText("");
            }
            this._order.setIcon(icon);
            bl3 = true;
            break;
        }
        if (!bl3) {
            this._order.setIcon(null);
            this._number.setText("");
        }
        return this;
    }

    class StringIcon
    implements Icon {
        private String string;

        public StringIcon(String string) {
            this.string = string;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.drawString(this.string, n, n2 + 10);
        }

        @Override
        public int getIconWidth() {
            return 12;
        }

        @Override
        public int getIconHeight() {
            return 12;
        }
    }
}

