/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing.live;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.UIResource;
import net.model3.collections.SetX;
import net.model3.logging.Log;
import net.model3.logging.LogHelper;
import net.model3.swing.GuiHelper;
import net.model3x.swing.ColumnHandler;
import net.model3x.swing.live.AdvancedPopup;
import net.model3x.swing.live.FilterPopup;
import net.model3x.swing.live.LiveTable;
import net.model3x.swing.live.LiveTableModel;
import net.model3x.swing.live.SortableFilterableHeaderRender;

public class LiveTableUtil {
    private static final Log logger = LogHelper.getLog(LiveTableUtil.class);

    public static <T> void addPopupsToTable(final LiveTable<T> liveTable, boolean bl) {
        final LiveTableModel<T> liveTableModel = liveTable.getModel();
        liveTable.getTableHeader().setDefaultRenderer(new SortableFilterableHeaderRender(liveTableModel));
        LiveTableUtil.configureEnclosingScrollPane(liveTable, bl);
        liveTable.getTableImpl().getTableHeader().setDefaultRenderer(new SortableFilterableHeaderRender(liveTableModel));
        liveTable.getTableImpl().getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                logger.debug((Object)mouseEvent);
                int n = liveTable.getTableImpl().convertColumnIndexToModel(liveTable.getTableImpl().getTableHeader().columnAtPoint(mouseEvent.getPoint()));
                ColumnHandler columnHandler = liveTableModel.getColumn(n);
                Set set = SetX.create();
                for (Object e : liveTableModel.getRoot()) {
                    set.add(columnHandler.getColumnValue(e, n));
                }
                FilterPopup filterPopup = new FilterPopup(liveTable, mouseEvent.getLocationOnScreen(), columnHandler, set);
                filterPopup.toString();
            }
        });
    }

    private static void configureEnclosingScrollPane(final LiveTable liveTable, final boolean bl) {
        liveTable.getTableHeaderContainer().removeAll();
        Container container = liveTable.getParent();
        if (container instanceof JViewport) {
            Container container2 = container.getParent();
            if (container2 instanceof JScrollPane) {
                JComponent jComponent;
                JScrollPane jScrollPane = (JScrollPane)container2;
                if (bl) {
                    jScrollPane.setVerticalScrollBarPolicy(22);
                    jComponent = new JButton("...");
                    ((AbstractButton)jComponent).addActionListener(new ActionListener((JButton)jComponent){
                        private static final long serialVersionUID = 1L;
                        final /* synthetic */ JButton val$button;
                        {
                            this.val$button = jButton;
                        }

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            new AdvancedPopup(liveTable, this.val$button.getLocationOnScreen()).toString();
                        }
                    });
                    jScrollPane.setCorner("UPPER_RIGHT_CORNER", jComponent);
                }
                if ((jComponent = jScrollPane.getViewport()) != null && ((JViewport)jComponent).getView() == liveTable) {
                    Border border;
                    liveTable.getTableHeaderContainer().setVisible(false);
                    jScrollPane.setColumnHeaderView(liveTable.getTableHeader());
                    Border border2 = jScrollPane.getBorder();
                    if ((border2 == null || border2 instanceof UIResource) && (border = UIManager.getBorder("Table.scrollPaneBorder")) != null) {
                        jScrollPane.setBorder(border);
                    }
                }
            }
        } else if (container != null) {
            liveTable.getTableHeaderContainer().setVisible(true);
            liveTable.getTableHeaderContainer().add(liveTable.getTableHeader());
        } else {
            liveTable.addAncestorListener(new AncestorListener(){

                void apply() {
                    if (liveTable.getParent() != null) {
                        LiveTableUtil.configureEnclosingScrollPane(liveTable, bl);
                        liveTable.removeAncestorListener(this);
                    }
                }

                @Override
                public void ancestorRemoved(AncestorEvent ancestorEvent) {
                    this.apply();
                }

                @Override
                public void ancestorMoved(AncestorEvent ancestorEvent) {
                    this.apply();
                }

                @Override
                public void ancestorAdded(AncestorEvent ancestorEvent) {
                    this.apply();
                }
            });
        }
        GuiHelper.doLayoutHack((Component)liveTable.getTableHeaderContainer());
    }
}

