/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing.live;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.gui.AdvancedTableFormat;
import ca.odell.glazedlists.impl.SyncListener;
import java.util.Comparator;
import java.util.List;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import net.java.dev.properties.container.PropertyContextable;
import net.model3.collections.ListX;
import net.model3.lang.ObjectX;
import net.model3x.swing.ColumnHandler;
import net.model3x.swing.PropertyContextColumnHandler;
import net.model3x.swing.RendererFactory;
import net.model3x.swing.live.EventTableModel;
import net.model3x.swing.table.ColumnFilter;

public class LiveTableModel<TRow>
extends EventTableModel<TRow> {
    List<ColumnHandler<TRow>> _allColumns = ListX.create();
    List<RowSorter.SortKey> _sortKeys = ListX.create();

    public LiveTableModel(EventList<TRow> eventList) {
        super(eventList, new M3TableFormat());
    }

    public LiveTableModel() {
        this((EventList<TRow>)new BasicEventList());
    }

    public void initializeDefaultCellRenderers(JTable jTable, RendererFactory rendererFactory) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            TableCellEditor tableCellEditor;
            ColumnHandler<TRow> columnHandler = this.getColumn(i);
            TableCellRenderer tableCellRenderer = columnHandler.getTableCellRenderer();
            if (tableCellRenderer == null && rendererFactory != null) {
                tableCellRenderer = rendererFactory.getTableCellRenderer(columnHandler.getColumnType());
            }
            if (tableCellRenderer != null) {
                jTable.getColumnModel().getColumn(i).setCellRenderer(tableCellRenderer);
            }
            if ((tableCellEditor = columnHandler.getTableCellEditor()) == null && rendererFactory != null) {
                tableCellEditor = rendererFactory.getTableCellEditor(columnHandler.getColumnType());
            }
            if (tableCellEditor == null) continue;
            jTable.getColumnModel().getColumn(i).setCellEditor(tableCellEditor);
        }
    }

    public void setLiveRows(EventList<TRow> eventList) {
        eventList.getReadWriteLock().readLock().lock();
        this.getRoot().getReadWriteLock().writeLock().lock();
        try {
            new SyncListener(eventList, this.getRoot());
        }
        finally {
            eventList.getReadWriteLock().readLock().unlock();
            this.getRoot().getReadWriteLock().writeLock().unlock();
        }
    }

    public int columnIndex(ColumnHandler<TRow> columnHandler) {
        return this.getColumns().indexOf(columnHandler);
    }

    @Override
    public M3TableFormat<? super TRow> getTableFormat() {
        return (M3TableFormat)super.getTableFormat();
    }

    public ColumnHandler<TRow> addColumn(PropertyContextable propertyContextable) {
        return this.addColumn(new PropertyContextColumnHandler(propertyContextable.getContext()));
    }

    public ColumnHandler<TRow> addColumn(ColumnHandler<TRow> columnHandler) {
        return this.addColumn(columnHandler, -1);
    }

    public ColumnHandler<TRow> addColumn(ColumnHandler<TRow> columnHandler, int n) {
        this.addAllColumn(columnHandler);
        List list = this.getTableFormat().copyHandlers();
        if (n < 0) {
            list.add(columnHandler);
        } else {
            list.add(n, columnHandler);
        }
        this.setTableFormat(new M3TableFormat(list));
        return columnHandler;
    }

    protected void addAllColumn(ColumnHandler<TRow> columnHandler) {
        if (!this._allColumns.contains(columnHandler)) {
            this._allColumns.add(columnHandler);
        }
    }

    public TRow getRow(int n) {
        this._source.getReadWriteLock().readLock().lock();
        try {
            Object object = this._source.get(n);
            return (TRow)object;
        }
        finally {
            this._source.getReadWriteLock().readLock().unlock();
        }
    }

    public ColumnHandler<TRow> getColumn(int n) {
        return (ColumnHandler)ObjectX.magicast(this.getTableFormat()._handlers.get(n));
    }

    public List<ColumnHandler<TRow>> getColumns() {
        return (List)ObjectX.magicast(this.getTableFormat()._handlers);
    }

    public void clearColumns() {
        this.setTableFormat(new M3TableFormat());
    }

    public boolean removeColumn(ColumnHandler<TRow> columnHandler) {
        List list = this.getTableFormat().copyHandlers();
        boolean bl = list.remove(columnHandler);
        this.setTableFormat(new M3TableFormat(list));
        return bl;
    }

    public List<ColumnHandler<TRow>> getAllColumns() {
        return this._allColumns;
    }

    public EventList<? extends TRow> getRows() {
        return this._source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addRow(TRow TRow) {
        this._root.getReadWriteLock().writeLock().lock();
        try {
            int n = this.getRowCount();
            this._root.add(TRow);
            int n2 = n;
            return n2;
        }
        finally {
            this._root.getReadWriteLock().writeLock().unlock();
        }
    }

    public void removeRow(TRow TRow) {
        this._root.getReadWriteLock().writeLock().lock();
        try {
            this._root.remove(TRow);
        }
        finally {
            this._root.getReadWriteLock().writeLock().unlock();
        }
    }

    public int getRowIndex(TRow TRow) {
        this._source.getReadWriteLock().readLock().lock();
        try {
            int n = this._source.indexOf(TRow);
            return n;
        }
        finally {
            this._source.getReadWriteLock().readLock().unlock();
        }
    }

    public List<RowSorter.SortKey> getSortKeys() {
        return this._sortKeys;
    }

    public void setSortKeys(List<RowSorter.SortKey> list) {
        List list2 = ListX.create();
        for (RowSorter.SortKey sortKey : list) {
            Comparator comparator = this.getTableFormat().getColumnComparator(sortKey.getColumn());
            if (sortKey.getSortOrder() == SortOrder.DESCENDING) {
                comparator = GlazedLists.reverseComparator((Comparator)comparator);
            }
            list2.add(comparator);
        }
        this._sortedList.setComparator(GlazedLists.chainComparators((List)list2));
        this._sortKeys = list;
    }

    public void addFilter(ColumnFilter columnFilter) {
        if (!this._filters.contains((Object)columnFilter)) {
            this._filters.add((Object)columnFilter);
        }
    }

    public void removeFilter(ColumnFilter columnFilter) {
        if (this._filters.contains((Object)columnFilter)) {
            this._filters.remove((Object)columnFilter);
        }
    }

    public static class M3TableFormat<T>
    implements AdvancedTableFormat<T> {
        List<ColumnHandler<T>> _handlers;

        public M3TableFormat() {
            this._handlers = ListX.create();
        }

        <U> List<ColumnHandler<U>> copyHandlers() {
            return (List)ObjectX.magicast((Object)ListX.create(this._handlers));
        }

        public M3TableFormat(List<ColumnHandler<T>> list) {
            this._handlers = list;
        }

        public int getColumnCount() {
            return this._handlers.size();
        }

        public String getColumnName(int n) {
            return this._handlers.get(n).getSingularName();
        }

        public Object getColumnValue(T t, int n) {
            return this._handlers.get(n).getColumnValue(t, -1);
        }

        public Class getColumnClass(int n) {
            return this._handlers.get(n).getColumnType();
        }

        public Comparator getColumnComparator(final int n) {
            return new Comparator<T>(){

                @Override
                public int compare(T t, T t2) {
                    Object object = this.getColumnValue(t, n);
                    Object object2 = this.getColumnValue(t2, n);
                    return ObjectX.compareTo((Object)object, (Object)object2);
                }
            };
        }
    }
}

