/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing.live;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.gui.AdvancedTableFormat;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.gui.WritableTableFormat;
import ca.odell.glazedlists.matchers.CompositeMatcherEditor;
import ca.odell.glazedlists.matchers.MatcherEditor;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import javax.swing.table.AbstractTableModel;
import net.model3x.swing.live.MutableTableModelEvent;
import net.model3x.swing.live.SafeComparator;

public class EventTableModel<E>
extends AbstractTableModel
implements ListEventListener<E> {
    protected TransformedList<E, E> _swingThreadSource;
    protected EventList<E> _root;
    protected EventList<E> _source;
    SortedList<E> _sortedList;
    FilterList<E> _filterList;
    EventList<MatcherEditor<E>> _filters = new BasicEventList();
    private TableFormat<? super E> tableFormat;
    private final MutableTableModelEvent tableModelEvent = new MutableTableModelEvent(this);

    public EventTableModel(EventList<E> eventList, TableFormat<? super E> tableFormat) {
        this.tableFormat = tableFormat;
        this.setRoot(eventList);
    }

    private void setRoot(EventList<E> eventList) {
        if (this._root != null) {
            this.dispose();
            this._filterList.dispose();
            this._sortedList.dispose();
        }
        this._root = eventList;
        this._root.getReadWriteLock().readLock().lock();
        try {
            this._sortedList = new SortedList(this._root, new SafeComparator());
            this._filterList = new FilterList(this._sortedList, (MatcherEditor)new CompositeMatcherEditor(this._filters));
            TransformedList<E, E> transformedList = this.createSwingThreadProxyList((EventList<E>)this._filterList);
            if (transformedList != null && transformedList != this._filterList) {
                this._swingThreadSource = transformedList;
                this._source = this._swingThreadSource;
            } else {
                this._source = this._filterList;
            }
            this._source.addListEventListener((ListEventListener)this);
        }
        finally {
            this._root.getReadWriteLock().readLock().unlock();
        }
    }

    public EventTableModel(EventList<E> eventList, String[] stringArray, String[] stringArray2, boolean[] blArray) {
        this(eventList, GlazedLists.tableFormat((String[])stringArray, (String[])stringArray2, (boolean[])blArray));
    }

    protected TransformedList<E, E> createSwingThreadProxyList(EventList<E> eventList) {
        return GlazedListsSwing.isSwingThreadProxyList(eventList) ? null : GlazedListsSwing.swingThreadProxyList(eventList);
    }

    public TableFormat<? super E> getTableFormat() {
        return this.tableFormat;
    }

    public void setTableFormat(TableFormat<E> tableFormat) {
        this.tableFormat = tableFormat;
        this.tableModelEvent.setStructureChanged();
        this.fireTableChanged(this.tableModelEvent);
    }

    public E getElementAt(int n) {
        this._source.getReadWriteLock().readLock().lock();
        try {
            Object object = this._source.get(n);
            return (E)object;
        }
        finally {
            this._source.getReadWriteLock().readLock().unlock();
        }
    }

    public void listChanged(ListEvent<E> listEvent) {
        this.handleListChange(listEvent);
    }

    public SortedList<E> getSortabledList() {
        return this._sortedList;
    }

    protected void handleListChange(ListEvent<E> listEvent) {
        while (listEvent.nextBlock()) {
            int n = listEvent.getBlockStartIndex();
            int n2 = listEvent.getBlockEndIndex();
            int n3 = listEvent.getType();
            this.tableModelEvent.setValues(n, n2, n3);
            this.fireTableChanged(this.tableModelEvent);
        }
    }

    protected final MutableTableModelEvent getMutableTableModelEvent() {
        return this.tableModelEvent;
    }

    @Override
    public String getColumnName(int n) {
        return this.tableFormat.getColumnName(n);
    }

    @Override
    public int getRowCount() {
        this._source.getReadWriteLock().readLock().lock();
        try {
            int n = this._source.size();
            return n;
        }
        finally {
            this._source.getReadWriteLock().readLock().unlock();
        }
    }

    @Override
    public int getColumnCount() {
        return this.tableFormat.getColumnCount();
    }

    public Class getColumnClass(int n) {
        if (this.tableFormat instanceof AdvancedTableFormat) {
            return ((AdvancedTableFormat)this.tableFormat).getColumnClass(n);
        }
        return super.getColumnClass(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueAt(int n, int n2) {
        this._source.getReadWriteLock().readLock().lock();
        try {
            Object object = this.tableFormat.getColumnValue(this._source.get(n), n2);
            return object;
        }
        finally {
            this._source.getReadWriteLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCellEditable(int n, int n2) {
        if (!(this.tableFormat instanceof WritableTableFormat)) {
            return false;
        }
        this._source.getReadWriteLock().readLock().lock();
        try {
            Object object = this._source.get(n);
            boolean bl = ((WritableTableFormat)this.tableFormat).isEditable(object, n2);
            return bl;
        }
        finally {
            this._source.getReadWriteLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (!(this.tableFormat instanceof WritableTableFormat)) {
            throw new UnsupportedOperationException("Unexpected setValueAt() on read-only table");
        }
        this._source.getReadWriteLock().writeLock().lock();
        try {
            Object object2 = this._source.get(n);
            WritableTableFormat writableTableFormat = (WritableTableFormat)this.tableFormat;
            Object object3 = writableTableFormat.setColumnValue(object2, object, n2);
            if (object3 != null) {
                boolean bl;
                boolean bl2 = bl = n < this.getRowCount() && this._source.get(n) == object2;
                if (bl) {
                    this._source.set(n, object3);
                }
            }
        }
        finally {
            this._source.getReadWriteLock().writeLock().unlock();
        }
    }

    public EventList<E> getRoot() {
        return this._root;
    }

    public EventList<MatcherEditor<E>> getFilters() {
        return this._filters;
    }

    public void dispose() {
        this._source.removeListEventListener((ListEventListener)this);
        if (this._swingThreadSource != null) {
            this._swingThreadSource.dispose();
        }
        this._swingThreadSource = null;
        this._source = null;
    }

    public EventList<E> getSource() {
        return this._source;
    }
}

