/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing.imageviewer;

import com.google.common.base.Function;
import com.google.inject.Inject;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.model3.collections.ListX;
import net.model3.guice.DependencyInjector;
import net.model3.imaging.ImageProxy;
import net.model3.imaging.Size;
import net.model3.lang.ObjectX;
import net.model3.logging.Log;
import net.model3.logging.LogHelper;
import net.model3.swing.FixedGridLayout;
import net.model3.swing.GuiHelper;
import net.model3x.swing.ComponentFactory;
import net.model3x.swing.HStringProvider;
import net.model3x.swing.M3Layout;
import net.model3x.swing.imageviewer.CollectionHelper;
import net.model3x.swing.imageviewer.ImageProxyPopupFactory;
import net.model3x.swing.imageviewer.Thumbnail;

public class ThumbnailStrip<T>
extends JPanel
implements Scrollable {
    private static Log logger = LogHelper.getLog();
    private static final long serialVersionUID = 5033107173079199660L;
    private Size _thumbnailSize = new Size(100, 100);
    private List<Thumbnail<T>> _thumbnails = new ArrayList<Thumbnail<T>>();
    private Set<Thumbnail<T>> _selectedThumbnails = new HashSet<Thumbnail<T>>();
    private ActionListener _selectionListener;
    private JScrollPane _scrollPane;
    private ImageProxyPopupFactory _popupFactory;
    private int _viewportWidth;
    private LinkedHashMap<Object, Group> _groups = new LinkedHashMap();
    private List<Group> _sortedGroups;
    @Inject
    ComponentFactory _componentFactory;
    private GroupingStrategy<T> _groupingStrategy;
    private CaptionProvider<T> _captionProvider;

    public ThumbnailStrip() {
        DependencyInjector.inject((Object)this);
        this._groupingStrategy = new GroupingStrategy<T>(){

            @Override
            public Object getGroupingField(T t) {
                return null;
            }

            @Override
            public Comparator<T> getComparator() {
                return null;
            }
        };
        this._captionProvider = new CaptionProvider<T>(){

            @Override
            public String getCaption(T t) {
                return null;
            }
        };
        this.setLayout((LayoutManager)new M3Layout("fillx"));
        this.setBackground(Color.WHITE);
        this.setOpaque(true);
    }

    public ThumbnailStrip(JScrollPane jScrollPane) {
        this();
        this._scrollPane = jScrollPane;
    }

    public void setSelectionListener(ActionListener actionListener) {
        this._selectionListener = actionListener;
    }

    public void setThumbnailSize(Size size) {
        this._thumbnailSize = size;
    }

    public Set<Thumbnail<T>> getSelectedThumbnails() {
        return this._selectedThumbnails;
    }

    public void addThumbnail(ImageProxy<T> imageProxy) {
        final Thumbnail<T> thumbnail = new Thumbnail<T>(imageProxy, this, this._thumbnailSize);
        thumbnail.addSelectListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Object object;
                if (mouseEvent.getButton() == 3 && ThumbnailStrip.this._popupFactory != null) {
                    if (!ThumbnailStrip.this._selectedThumbnails.contains(thumbnail)) {
                        for (Iterator iterator : ThumbnailStrip.this._selectedThumbnails) {
                            ((Thumbnail)((Object)iterator)).setUnselectedBorder();
                        }
                        ThumbnailStrip.this._selectedThumbnails.clear();
                        ThumbnailStrip.this._selectedThumbnails.add(thumbnail);
                        thumbnail.setSelectedBorder();
                    }
                    object = ThumbnailStrip.this._popupFactory.createPopup(thumbnail.getImage());
                    ((JPopupMenu)object).show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
                if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 1) {
                    Iterator iterator;
                    object = new HashSet();
                    if (mouseEvent.isControlDown() && !mouseEvent.isShiftDown() && !mouseEvent.isAltDown()) {
                        object.addAll(ThumbnailStrip.this._selectedThumbnails);
                    }
                    if (object.contains(thumbnail)) {
                        object.remove(thumbnail);
                    } else {
                        object.add(thumbnail);
                    }
                    for (Thumbnail thumbnail22 : ThumbnailStrip.this._selectedThumbnails) {
                        thumbnail22.setUnselectedBorder();
                    }
                    iterator = object.iterator();
                    while (iterator.hasNext()) {
                        Thumbnail thumbnail22;
                        thumbnail22 = (Thumbnail)iterator.next();
                        thumbnail22.setSelectedBorder();
                    }
                    ThumbnailStrip.this._selectedThumbnails = (Set)object;
                    if (ThumbnailStrip.this._selectionListener != null) {
                        ThumbnailStrip.this._selectionListener.actionPerformed(null);
                    }
                }
            }
        });
        this._thumbnails.add(thumbnail);
        this.getGroup(thumbnail).add(thumbnail);
        this.doLayoutHack();
        this.resetGroups();
    }

    private void doLayoutHack() {
        GuiHelper.doLayoutHack((Component)this);
        if (this._scrollPane != null) {
            GuiHelper.doLayoutHack((Component)this._scrollPane);
        }
    }

    public List<ImageProxy<T>> getImageCollection() {
        List list = ListX.create();
        for (Group group : this._sortedGroups) {
            for (Thumbnail thumbnail : group._thumbnails) {
                list.add(thumbnail.getImage());
            }
        }
        return list;
    }

    public int getScanCount() {
        return this._thumbnails.size();
    }

    public void setScrollPane(JScrollPane jScrollPane) {
        this._scrollPane = jScrollPane;
        this._scrollPane.getViewport().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                int n = ThumbnailStrip.this._scrollPane.getViewport().getWidth();
                if (ThumbnailStrip.this._viewportWidth != n) {
                    ThumbnailStrip.this._viewportWidth = n;
                    logger.trace((Object)"view port width = {}", (Object)ThumbnailStrip.this._viewportWidth);
                    for (Group group : ThumbnailStrip.this._groups.values()) {
                        if (group._layout.getMaximumWidth() == ThumbnailStrip.this._viewportWidth) continue;
                        group._layout.setMaximumWidth(ThumbnailStrip.this._viewportWidth);
                        GuiHelper.doLayoutHack((Component)group._panel);
                    }
                    ThumbnailStrip.this.doLayoutHack();
                }
            }
        });
    }

    public void setPopupFactory(ImageProxyPopupFactory imageProxyPopupFactory) {
        this._popupFactory = imageProxyPopupFactory;
    }

    public void removeAllThumbnails() {
        this._thumbnails.clear();
        this.resetCaptions();
        this.resetGroups();
    }

    public void removeThumbnail(T t) {
        Thumbnail<T> thumbnail = null;
        for (Thumbnail<T> thumbnail2 : this._thumbnails) {
            if (!thumbnail2.getImage().getDelegate().equals(t)) continue;
            thumbnail = thumbnail2;
            break;
        }
        if (thumbnail != null) {
            this._thumbnails.remove(thumbnail);
            this.remove(thumbnail);
            this.resetCaptions();
        }
    }

    public void resetCaptions() {
        for (Thumbnail<T> thumbnail : this._thumbnails) {
            thumbnail.setCaption(this._captionProvider.getCaption(thumbnail.getDelegate()));
        }
    }

    public Thumbnail<T> getThumbnailByImageProxy(ImageProxy<T> imageProxy) {
        for (Thumbnail<T> thumbnail : this._thumbnails) {
            if (thumbnail.getImage() != imageProxy) continue;
            return thumbnail;
        }
        return null;
    }

    public Thumbnail<T> getThumbnailByReference(T t) {
        for (Thumbnail<T> thumbnail : this._thumbnails) {
            if (!thumbnail.getImage().getDelegate().equals(t)) continue;
            return thumbnail;
        }
        return null;
    }

    public GroupingStrategy<T> getGroupingStrategy() {
        return this._groupingStrategy;
    }

    public void setGroupingStrategy(GroupingStrategy<T> groupingStrategy) {
        this._groupingStrategy = groupingStrategy;
        this.resetGroups();
    }

    public void resetGroups() {
        this._groups.clear();
        this.removeAll();
        for (Thumbnail<T> object2 : this._thumbnails) {
            object2.setCaption(this._captionProvider.getCaption(object2.getDelegate()));
            this.getGroup(object2).add(object2);
        }
        ArrayList<Group> arrayList = new ArrayList<Group>(this._groups.values());
        Collections.sort(arrayList, new Comparator<Group>(){

            @Override
            public int compare(Group group, Group group2) {
                return ObjectX.compareTo((Object)group._groupingField, (Object)group2._groupingField);
            }
        });
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Group group = (Group)iterator.next();
            group.sort();
            if (group._groupingField != null) {
                String string = ((HStringProvider)DependencyInjector.getInstance(HStringProvider.class)).toString(group._groupingField);
                String string2 = this._groupingStrategy + " " + string;
                this.add((Component)this._componentFactory.createTitledSeperator(string2), "wrap");
            }
            this.add((Component)group.createPanel(), "wrap");
        }
        this._sortedGroups = arrayList;
        this.resetCaptions();
        this.doLayoutHack();
    }

    private Group getGroup(Thumbnail<T> thumbnail) {
        Object object = this._groupingStrategy.getGroupingField(thumbnail.getDelegate());
        Group group = this._groups.get(object);
        if (group == null) {
            group = new Group();
            group._groupingField = object;
            this._groups.put(object, group);
        }
        return group;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return null;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return 15;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return 15;
    }

    public void setCaptionProvider(CaptionProvider<T> captionProvider) {
        this._captionProvider = captionProvider;
        this.resetCaptions();
    }

    public List<T> getDelegates() {
        List list = ListX.create();
        for (Thumbnail<T> thumbnail : this._thumbnails) {
            list.add(thumbnail.getDelegate());
        }
        return list;
    }

    public List<T> getSelectedDelegates() {
        List list = ListX.create();
        for (Thumbnail<T> thumbnail : this._selectedThumbnails) {
            list.add(thumbnail.getDelegate());
        }
        return list;
    }

    public ImageProxyPopupFactory getPopupFactory() {
        return this._popupFactory;
    }

    public static interface CaptionProvider<T> {
        public String getCaption(T var1);
    }

    public static abstract class GroupingStrategy<U> {
        public abstract Object getGroupingField(U var1);

        public boolean showOnCaption() {
            return true;
        }

        public abstract Comparator<U> getComparator();
    }

    class Group {
        List<Thumbnail<T>> _thumbnails = new ArrayList();
        Object _groupingField;
        FixedGridLayout _layout = new FixedGridLayout();
        JPanel _panel;

        Group() {
        }

        JPanel createPanel() {
            this._panel = new JPanel();
            this._panel.setBackground(Color.white);
            this._layout.setMaximumWidth(ThumbnailStrip.this._viewportWidth);
            this._panel.setLayout((LayoutManager)this._layout);
            for (Thumbnail thumbnail : this._thumbnails) {
                this._panel.add(thumbnail);
            }
            return this._panel;
        }

        void add(Thumbnail<T> thumbnail) {
            this._thumbnails.add(thumbnail);
            if (this._panel != null) {
                this._panel.add(thumbnail);
            }
        }

        void sort() {
            if (ThumbnailStrip.this._groupingStrategy.getComparator() != null) {
                final Comparator comparator = ThumbnailStrip.this._groupingStrategy.getComparator();
                Function function = new Function<Thumbnail<T>, T>(){

                    public T apply(Thumbnail<T> thumbnail) {
                        return thumbnail.getDelegate();
                    }
                };
                CollectionHelper.reducingSort(this._thumbnails, function, new Comparator<T>(){

                    @Override
                    public int compare(T t, T t2) {
                        int n = comparator.compare(t, t2);
                        if (n == 0) {
                            if (t instanceof Comparable && t2 instanceof Comparable) {
                                return ObjectX.compareTo(t, t2);
                            }
                            return 0;
                        }
                        return n;
                    }
                });
            }
        }
    }
}

