/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing.imageviewer;

import com.google.inject.Inject;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import net.model3.guice.DependencyInjector;
import net.model3.imaging.ImageProxy;
import net.model3.imaging.ImageProxyListener;
import net.model3.imaging.Size;
import net.model3.logging.Log;
import net.model3.logging.LogHelper;
import net.model3.swing.CurvedBorder;
import net.model3x.swing.imageviewer.ImageViewer;
import net.model3x.swing.imageviewer.ThumbnailStrip;

public class Thumbnail<T>
extends JPanel {
    private static final Log logger = LogHelper.getLog();
    private static final long serialVersionUID = 0L;
    private JLabel _imageLabel = new JLabel();
    private JLabel _textLabel = new JLabel();
    private boolean _selected = false;
    private ImageProxy<T> _imageProxy;
    private Size _imageSize;
    private BufferedImage _image = null;
    private ThumbnailStrip<T> _thumbnailStrip;
    private ImageProxyListener<T> _imageProxyListener = new ImageProxyListener<T>(){

        public void imageChanged(ImageProxy<T> imageProxy) {
            if (Thumbnail.this._imageProxy == imageProxy) {
                Thumbnail.this.resetImage();
            }
        }
    };
    @Inject
    ImageViewer _imageViewer;

    public Thumbnail(ImageProxy<T> imageProxy, ThumbnailStrip<T> thumbnailStrip, Size size) {
        DependencyInjector.inject((Object)this);
        this._imageProxy = imageProxy;
        this._imageSize = size;
        this._thumbnailStrip = thumbnailStrip;
        this._imageLabel.setBackground(Color.BLUE);
        this._imageLabel.setBorder(new LineBorder(Color.GRAY, 1));
        this.setBackground(Color.white);
        this.setOpaque(true);
        this._imageLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
                    Thumbnail.this._imageViewer.showImage(Thumbnail.this._imageProxy, Thumbnail.this._thumbnailStrip.getImageCollection(), Thumbnail.this._thumbnailStrip.getPopupFactory());
                }
            }
        });
        this._imageProxy.getImageProxyContainer().getEventManager().addListener(this._imageProxyListener);
        this.setLayout(new BoxLayout(this, 1));
        this._imageLabel.setAlignmentX(0.5f);
        this._textLabel.setAlignmentX(0.5f);
        this.setUnselectedBorder();
        this.add(this._imageLabel);
        this.add(this._textLabel);
        this._textLabel.setBorder(new EmptyBorder(2, 0, 2, 0));
        this._textLabel.setHorizontalTextPosition(0);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (this._image == null) {
            this.resetImage();
        }
        super.paintComponent(graphics);
    }

    public void resetImage() {
        final BufferedImage bufferedImage = this._imageProxy.getImage(this._imageSize);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Thumbnail.this.setImage(bufferedImage);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void setSelectedBorder() {
        int n = 2;
        this.setBorder(new CompoundBorder((Border)new CurvedBorder(Color.GRAY, n, 10), new EmptyBorder(5 - n, 15 - n, 5 - n, 15 - n)));
    }

    public void setUnselectedBorder() {
        this.setBorder(new EmptyBorder(5, 15, 5, 15));
    }

    public ThumbnailStrip<T> getThumbnailStrip() {
        return this._thumbnailStrip;
    }

    private void setImage(BufferedImage bufferedImage) {
        this._image = bufferedImage;
        this._imageLabel.setIcon(new ImageIcon(bufferedImage));
    }

    public void setImageProxy(ImageProxy<T> imageProxy) {
        ImageProxy<T> imageProxy2 = this._imageProxy;
        if (imageProxy2 != null) {
            imageProxy2.getImageProxyContainer().getEventManager().addListener(this._imageProxyListener);
        }
        this._imageProxy = imageProxy;
        this.resetImage();
        this._imageProxy.getImageProxyContainer().getEventManager().addListener(this._imageProxyListener);
    }

    public void addSelectListener(MouseListener mouseListener) {
        this._imageLabel.addMouseListener(mouseListener);
        this._textLabel.addMouseListener(mouseListener);
        this.addMouseListener(mouseListener);
    }

    public ImageProxy<T> getImage() {
        return this._imageProxy;
    }

    public void setCaption(String string) {
        this._textLabel.setText(string);
        logger.trace((Object)"text={}", (Object)string);
    }

    public boolean isSelected() {
        return this._selected;
    }

    public T getDelegate() {
        return (T)this.getImage().getDelegate();
    }

    static {
        logger.toString();
    }
}

