/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing.imageviewer;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JFrame;
import net.model3.imaging.BufferedImageProxy;
import net.model3.imaging.ImageProxy;
import net.model3.imaging.ImageUtils;
import net.model3.imaging.Size;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.newfile.File;

public class Magnifier
extends JComponent {
    private static final Logger logger = LoggerHelper.getLogger();
    private BufferedImage _magnifierImage;
    private Point _magnifierLocation;
    private Size _magnifierSize = new Size(500, 300);
    private BufferedImage _originalImage;
    private Size _originalImageSize;
    private BufferedImage _scaledImage;
    private Size _scaledImageSize;
    private Point _scaledImageLocation;
    private ImageProxy<?> _imageProxy;
    private Size _currentSize;

    public Magnifier(ImageProxy<?> imageProxy) {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Magnifier.this.showMagnifier(mouseEvent.getPoint());
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                Magnifier.this._magnifierLocation = null;
                Magnifier.this.repaint();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                Magnifier.this.showMagnifier(mouseEvent.getPoint());
            }
        });
        this.setImageProxy(imageProxy);
    }

    public void setImageProxy(ImageProxy<?> imageProxy) {
        if (imageProxy == null) {
            this._originalImage = null;
            this._originalImageSize = null;
            this._magnifierImage = null;
            this._imageProxy = null;
        } else {
            this._imageProxy = imageProxy;
            this._originalImage = this._imageProxy.getImage(null, imageProxy.getRotation());
            this._originalImageSize = new Size(this._originalImage);
            this._magnifierImage = ImageUtils.createOpaqueImage((Size)this._magnifierSize);
        }
        this._currentSize = null;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        graphics.clearRect(0, 0, this.getWidth(), this.getHeight());
        super.paintComponent(graphics);
        if (this._currentSize == null || this._currentSize.getWidth() != this.getWidth() || this._currentSize.getHeight() != this.getHeight()) {
            this.resetSize();
        }
        if (this._scaledImage != null && this._scaledImageLocation != null) {
            graphics.drawImage(this._scaledImage, this._scaledImageLocation.x, this._scaledImageLocation.y, null);
        }
        if (this._magnifierLocation != null && this._magnifierImage != null && this._magnifierLocation != null) {
            graphics.drawImage(this._magnifierImage, this._magnifierLocation.x, this._magnifierLocation.y, null);
        }
    }

    void resetSize() {
        if (this._originalImageSize == null) {
            return;
        }
        this._currentSize = new Size(this.getWidth(), this.getHeight());
        this._scaledImageSize = this._currentSize.createAspected(this._originalImageSize, true);
        this._scaledImage = ImageUtils.createScaledImage((BufferedImage)this._originalImage, (Size)this._scaledImageSize, (boolean)false, (boolean)false, (boolean)true);
        this._scaledImageLocation = new Point();
        this._scaledImageLocation.x = (this.getWidth() - this._scaledImageSize.getWidth()) / 2;
        this._scaledImageLocation.y = (this.getHeight() - this._scaledImageSize.getHeight()) / 2;
    }

    public static void main(String[] stringArray) {
        File file = new File("test.tif");
        BufferedImageProxy bufferedImageProxy = new BufferedImageProxy(file, "uuid", "title", null);
        Magnifier magnifier = new Magnifier((ImageProxy<?>)bufferedImageProxy);
        JFrame jFrame = new JFrame();
        jFrame.setDefaultCloseOperation(3);
        jFrame.add(magnifier);
        jFrame.setSize(800, 800);
        jFrame.setVisible(true);
    }

    public void flushImages() {
        this._magnifierImage.flush();
        this._originalImage.flush();
        this._scaledImage.flush();
        this._scaledImage = null;
        this._originalImage = null;
        this._magnifierImage = null;
    }

    void showMagnifier(Point point) {
        double d = this._scaledImageSize.calculateScale(this._originalImageSize);
        int n = (int)((point.getX() - (double)this._scaledImageLocation.x) / d);
        int n2 = (int)((point.getY() - (double)this._scaledImageLocation.y) / d);
        int n3 = this._magnifierSize.getWidth() / 2;
        int n4 = this._magnifierSize.getHeight() / 2;
        Graphics2D graphics2D = this._magnifierImage.createGraphics();
        graphics2D.setColor(this.getBackground());
        graphics2D.fillRect(0, 0, this._magnifierSize.getWidth(), this._magnifierSize.getHeight());
        Rectangle rectangle = new Rectangle(n - n3, n2 - n4, this._magnifierSize.getWidth(), this._magnifierSize.getHeight());
        Rectangle rectangle2 = new Rectangle(0, 0, this._originalImageSize.getWidth(), this._originalImage.getHeight());
        Rectangle rectangle3 = rectangle.intersection(rectangle2);
        if (rectangle3.width > 0 && rectangle3.height > 0) {
            int n5 = rectangle3.x - rectangle.x;
            int n6 = rectangle3.y - rectangle.y;
            int n7 = rectangle3.width;
            int n8 = rectangle3.height;
            logger.trace(new Object[]{"dx={}  dy={}  dw={}  dh={}", n5, n6, n7, n8});
            graphics2D.setColor(Color.blue);
            BufferedImage bufferedImage = this._originalImage.getSubimage(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
            graphics2D.drawImage((Image)bufferedImage, n5, n6, null);
            bufferedImage.flush();
            graphics2D.dispose();
        }
        System.out.println(rectangle3);
        this._magnifierLocation = new Point(point.x - n3, point.y - n4);
        this.repaint();
    }
}

