/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing.imageviewer;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.RenderedImage;
import java.io.InputStream;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import net.model3.imaging.ImageProxy;
import net.model3.imaging.ImageProxyListener;
import net.model3.imaging.Size;
import net.model3.io.IOHelper;
import net.model3.logging.Log;
import net.model3.logging.LogHelper;
import net.model3.newfile.File;
import net.model3x.swing.CenteringLayout;
import net.model3x.swing.imageviewer.ExtensionFileFilter;
import net.model3x.swing.imageviewer.ImageProxyPopupFactory;
import net.model3x.swing.imageviewer.Magnifier;
import net.model3x.swing.uistate.FrameStateMarshaller;
import org.jdesktop.layout.GroupLayout;

@Singleton
public class ImageViewer
extends JPanel {
    private static final double ZOOM_COEFFICIENT = 1.5;
    private static final long serialVersionUID = 1L;
    private static final Log logger = LogHelper.getLog();
    ImageProxyListener<?> _imageProxyListener = new ImageProxyListener<Object>(){

        public void imageChanged(ImageProxy<Object> imageProxy) {
            if (imageProxy == ImageViewer.this.getCurrentImage()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ImageViewer.this.resetImage();
                    }
                });
            }
        }
    };
    boolean _imageReset = false;
    @Inject
    FrameStateMarshaller _frameStateMarshaller;
    private final JFileChooser _fileChooser = new JFileChooser();
    private final ExtensionFileFilter _jpegFileFilter = new ExtensionFileFilter("jpeg file");
    private final ExtensionFileFilter _pngFileFilter;
    private JButton _closeButton;
    private JButton _nextPage;
    private JLabel _pageCountLabel;
    private JButton _previousPage;
    private JButton _rotateClockwise;
    private JButton _rotateCounterClockwise;
    private JScrollPane _scrollpane;
    private JToolBar _toolbar;
    private JPanel _viewport;
    private JButton _workflowHistoryButton;
    private JButton _zoomIn;
    private JButton _zoomOut;
    private int _zoomFactor;
    private ImageProxy<?> _imageProxy;
    private Size _initialSize;
    private List<ImageProxy<?>> _imageCollection;
    private Magnifier _imageMagnifier;
    private Point _dragMouseStart;
    private Point _dragViewportStart;
    private JFrame _parentFrame;
    private ImageProxyPopupFactory _popupFactory;
    private Font _pageXofYFont;

    public JButton getCloseButton() {
        return this._closeButton;
    }

    public void showImage(ImageProxy<?> imageProxy, List<ImageProxy<?>> list, ImageProxyPopupFactory imageProxyPopupFactory) {
        this.setPopupFactory(imageProxyPopupFactory);
        this.setImageCollection(list);
        this.resetImage(imageProxy);
        if (this.getParentFrame() == null) {
            JFrame jFrame = new JFrame();
            jFrame.setName("image-viewer");
            jFrame.add(this);
            jFrame.setSize(800, 600);
            this.setParentFrame(jFrame);
            this._frameStateMarshaller.attach(jFrame);
        }
        this.getParentFrame().setVisible(true);
    }

    public void saveImage(Component component, ImageProxy<?> imageProxy) {
        File file = new File(this._fileChooser.getCurrentDirectory(), imageProxy.getUuid());
        this._fileChooser.setSelectedFile(file.asFile());
        int n = this._fileChooser.showSaveDialog(component);
        if (n == 0) {
            File file2 = new File(this._fileChooser.getSelectedFile());
            ExtensionFileFilter extensionFileFilter = this._fileChooser.getFileFilter() instanceof ExtensionFileFilter ? (ExtensionFileFilter)this._fileChooser.getFileFilter() : this._jpegFileFilter;
            file2 = new File(extensionFileFilter.addExtensionIfNecessary(file2.asFile()));
            String string = extensionFileFilter == this._pngFileFilter ? "png" : "jpeg";
            try {
                ImageIO.write((RenderedImage)imageProxy.getImage(), string, file2.asFile());
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(component, "Unable to save image.  " + exception.getMessage());
            }
        }
    }

    public ImageViewer() {
        this._jpegFileFilter.addExtension(".jpeg");
        this._jpegFileFilter.addExtension(".jpg");
        this._pngFileFilter = new ExtensionFileFilter("png file");
        this._pngFileFilter.addExtension(".png");
        this._fileChooser.addChoosableFileFilter(this._jpegFileFilter);
        this._fileChooser.addChoosableFileFilter(this._pngFileFilter);
        this._zoomFactor = 0;
        this.setBackground(Color.white);
        this.initComponents();
        this._workflowHistoryButton.setVisible(false);
        ImageViewer.setToolbarIcon(this._zoomIn, "zoom-in.png");
        ImageViewer.setToolbarIcon(this._zoomOut, "zoom-out.png");
        ImageViewer.setToolbarIcon(this._rotateClockwise, "rotate-cw.png");
        ImageViewer.setToolbarIcon(this._rotateCounterClockwise, "rotate-ccw.png");
        ImageViewer.setToolbarIcon(this._previousPage, "previous.png");
        ImageViewer.setToolbarIcon(this._nextPage, "next.png");
        this._imageMagnifier = new Magnifier(null){

            @Override
            protected void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                Color color = graphics.getColor();
                Font font = graphics.getFont();
                if (ImageViewer.this._pageXofYFont == null) {
                    ImageViewer.this._pageXofYFont = new Font("Tahoma", 1, 12);
                }
                graphics.setFont(ImageViewer.this._pageXofYFont);
                graphics.drawString("Page", 10, 25);
                graphics.drawString(ImageViewer.this.getCurrentImageIndex() + 1 + " of " + ImageViewer.this.getPageCount(), 10, 40);
                graphics.setColor(color);
                graphics.setFont(font);
            }
        };
        this._imageMagnifier.setOpaque(true);
        this._viewport.setLayout(new CenteringLayout());
        this._viewport.add(this._imageMagnifier);
        this._imageMagnifier.setCursor(new Cursor(12));
        this._imageMagnifier.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                ImageViewer.this._dragViewportStart = ImageViewer.this._scrollpane.getViewport().getViewPosition();
                ImageViewer.this._dragMouseStart = mouseEvent.getLocationOnScreen();
            }
        });
        this._imageMagnifier.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                int n;
                Point point = new Point();
                point.x = ((ImageViewer)ImageViewer.this)._dragViewportStart.x + (((ImageViewer)ImageViewer.this)._dragMouseStart.x - mouseEvent.getXOnScreen());
                point.y = ((ImageViewer)ImageViewer.this)._dragViewportStart.y + (((ImageViewer)ImageViewer.this)._dragMouseStart.y - mouseEvent.getYOnScreen());
                Rectangle rectangle = ImageViewer.this._scrollpane.getViewport().getViewRect();
                int n2 = ImageViewer.this._imageMagnifier.getWidth() - rectangle.width;
                if (point.x > n2) {
                    point.x = n2;
                }
                if (point.y > (n = ImageViewer.this._imageMagnifier.getHeight() - rectangle.height)) {
                    point.y = n;
                }
                if (point.x < 0) {
                    point.x = 0;
                }
                if (point.y < 0) {
                    point.y = 0;
                }
                ImageViewer.this._scrollpane.getViewport().setViewPosition(point);
            }
        });
        this._imageMagnifier.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 3 && ImageViewer.this._popupFactory != null) {
                    JPopupMenu jPopupMenu = ImageViewer.this._popupFactory.createPopup(ImageViewer.this._imageProxy);
                    jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        this._scrollpane.setBackground(Color.WHITE);
        this._viewport.setBackground(Color.WHITE);
        this._closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingUtilities.getWindowAncestor(ImageViewer.this._closeButton).dispose();
            }
        });
        this._closeButton.setToolTipText("Close window");
        this._workflowHistoryButton.setToolTipText("Show workflow history");
        this._rotateClockwise.setToolTipText("Rotate image clockwise");
        this._rotateCounterClockwise.setToolTipText("Rotate image counter-clockwise");
        this._zoomIn.setToolTipText("Zoom into the image");
        this._zoomOut.setToolTipText("Zoom out from the image");
    }

    public ImageViewer(ImageProxy<?> imageProxy) {
        this();
        this._imageProxy = imageProxy;
    }

    public void setPopupFactory(ImageProxyPopupFactory imageProxyPopupFactory) {
        this._popupFactory = imageProxyPopupFactory;
    }

    private void initComponents() {
        this._toolbar = new JToolBar();
        this._zoomIn = new JButton();
        this._zoomOut = new JButton();
        this._rotateClockwise = new JButton();
        this._rotateCounterClockwise = new JButton();
        this._previousPage = new JButton();
        this._nextPage = new JButton();
        this._closeButton = new JButton();
        this._workflowHistoryButton = new JButton();
        this._pageCountLabel = new JLabel();
        this._scrollpane = new JScrollPane();
        this._viewport = new JPanel();
        this.setBackground(Color.white);
        this._toolbar.setBackground(Color.white);
        this._toolbar.setOrientation(1);
        this._zoomIn.setBackground(Color.white);
        this._zoomIn.setText("Zoom In");
        this._zoomIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImageViewer.this._zoomInActionPerformed(actionEvent);
            }
        });
        this._toolbar.add(this._zoomIn);
        this._zoomOut.setBackground(Color.white);
        this._zoomOut.setText("Zoom Out");
        this._zoomOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImageViewer.this._zoomOutActionPerformed(actionEvent);
            }
        });
        this._toolbar.add(this._zoomOut);
        this._rotateClockwise.setBackground(Color.white);
        this._rotateClockwise.setText("Rotate Clockwise");
        this._rotateClockwise.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImageViewer.this._rotateClockwiseActionPerformed(actionEvent);
            }
        });
        this._toolbar.add(this._rotateClockwise);
        this._rotateCounterClockwise.setBackground(Color.white);
        this._rotateCounterClockwise.setText("Rotate Counter Clockwise");
        this._rotateCounterClockwise.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImageViewer.this._rotateCounterClockwiseActionPerformed(actionEvent);
            }
        });
        this._toolbar.add(this._rotateCounterClockwise);
        this._previousPage.setBackground(Color.white);
        this._previousPage.setText("Previous Page");
        this._previousPage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImageViewer.this._previousPageActionPerformed(actionEvent);
            }
        });
        this._toolbar.add(this._previousPage);
        this._nextPage.setBackground(Color.white);
        this._nextPage.setText("Next Page");
        this._nextPage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImageViewer.this._nextPageActionPerformed(actionEvent);
            }
        });
        this._toolbar.add(this._nextPage);
        this._closeButton.setBackground(new Color(255, 255, 255));
        this._closeButton.setText("X");
        this._toolbar.add(this._closeButton);
        this._workflowHistoryButton.setBackground(new Color(255, 255, 255));
        this._workflowHistoryButton.setText("H");
        this._toolbar.add(this._workflowHistoryButton);
        this._pageCountLabel.setText("   page x of y");
        this._toolbar.add(this._pageCountLabel);
        this._scrollpane.setBackground(Color.white);
        this._scrollpane.setBorder(null);
        GroupLayout groupLayout = new GroupLayout((Container)this._viewport);
        this._viewport.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 537, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 448, Short.MAX_VALUE));
        this._scrollpane.setViewportView(this._viewport);
        GroupLayout groupLayout2 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this._toolbar, -2, 26, -2).addPreferredGap(0).add((Component)this._scrollpane, -1, 537, Short.MAX_VALUE)));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this._toolbar, -2, 437, -2).addContainerGap(-1, Short.MAX_VALUE)).add(2, (Component)this._scrollpane, -2, 0, Short.MAX_VALUE));
    }

    private void _nextPageActionPerformed(ActionEvent actionEvent) {
        this.nextPage();
    }

    private void _previousPageActionPerformed(ActionEvent actionEvent) {
        this.previousPage();
    }

    private void _zoomInActionPerformed(ActionEvent actionEvent) {
        ++this._zoomFactor;
        this.resetImage();
    }

    private void _zoomOutActionPerformed(ActionEvent actionEvent) {
        --this._zoomFactor;
        this.resetImage();
    }

    private void _rotateClockwiseActionPerformed(ActionEvent actionEvent) {
        this._imageReset = false;
        this._imageProxy.setRotation(this._imageProxy.getRotation().rotateClockwise());
        if (!this._imageReset) {
            this.resetImage();
        }
    }

    private void _rotateCounterClockwiseActionPerformed(ActionEvent actionEvent) {
        this._imageReset = false;
        this._imageProxy.setRotation(this._imageProxy.getRotation().rotateCounterClockwise());
        if (!this._imageReset) {
            this.resetImage();
        }
    }

    void resetImage() {
        this._imageReset = true;
        double d = this._zoomFactor > 0 ? Math.pow(1.5, this._zoomFactor) : (this._zoomFactor < 0 ? Math.pow(0.6666666666666666, Math.abs(this._zoomFactor)) : 1.0);
        Size size = this._initialSize.scale(d);
        this._imageMagnifier.setImageProxy(this._imageProxy);
        this._imageMagnifier.setSize(size.asDimension());
        this._imageMagnifier.setPreferredSize(size.asDimension());
        this._scrollpane.invalidate();
        this._scrollpane.repaint();
        this._scrollpane.getViewport().removeAll();
        this._scrollpane.getViewport().add(this._imageMagnifier);
        logger.debug((Object)"image size set to {}", (Object)size);
        boolean bl = this._imageCollection != null && this._imageCollection.indexOf(this._imageProxy) >= 0;
        this._nextPage.setVisible(bl);
        this._previousPage.setVisible(bl);
        if (this._parentFrame != null) {
            this._parentFrame.setTitle(this._imageProxy.getDelegate().toString());
        }
    }

    public void nextPage() {
        this.incrementDecrementImage(1);
    }

    public void previousPage() {
        this.incrementDecrementImage(-1);
    }

    public void setImageCollection(List<ImageProxy<?>> list) {
        this._imageCollection = list;
    }

    public int getCurrentImageIndex() {
        if (this._imageCollection == null) {
            return 0;
        }
        return this._imageCollection.indexOf(this._imageProxy);
    }

    public int getPageCount() {
        if (this._imageCollection == null) {
            return 1;
        }
        return this._imageCollection.size();
    }

    void incrementDecrementImage(int n) {
        if (this._imageCollection == null) {
            return;
        }
        int n2 = this._imageCollection.indexOf(this._imageProxy);
        if (n2 == -1) {
            return;
        }
        int n3 = 0;
        int n4 = this._imageCollection.size() - 1;
        if ((n2 += n) < 0) {
            n2 = n4;
        } else if (n2 > n4) {
            n2 = n3;
        }
        this.resetImage(this._imageCollection.get(n2));
    }

    public void resetImage(ImageProxy<?> imageProxy) {
        Size size = imageProxy.getImageSize();
        if (size.getHeight() > 600 || size.getWidth() > 600) {
            size = new Size(600, 600);
        }
        this.resetImage(imageProxy, size);
        this._pageCountLabel.setVisible(false);
        this._scrollpane.getViewport().setViewPosition(new Point(0, 0));
    }

    int getCollectionSize() {
        if (this._imageCollection == null) {
            return 1;
        }
        return this._imageCollection.size();
    }

    void resetImage(ImageProxy<?> imageProxy, Size size) {
        if (imageProxy != this._imageProxy) {
            ImageProxy<?> imageProxy2 = this._imageProxy;
            if (imageProxy2 != null) {
                imageProxy2.getImageProxyContainer().getEventManager().removeListener(this._imageProxyListener);
            }
            this._imageProxy = imageProxy;
            this._imageMagnifier.setImageProxy(this._imageProxy);
            this._imageProxy.getImageProxyContainer().getEventManager().addListener(this._imageProxyListener);
        }
        this._zoomFactor = 1;
        this._initialSize = size == null ? imageProxy.getImageSize() : size;
        this.resetImage();
        this._imageProxy.getImageProxyContainer().fullSizeViewEvent(this._imageProxy);
    }

    public void flushImages() {
        if (this._imageMagnifier != null) {
            this._imageMagnifier.flushImages();
            this._imageMagnifier = null;
            try {
                this._viewport.remove(this._imageMagnifier);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setParentFrame(JFrame jFrame) {
        this._parentFrame = jFrame;
    }

    public ImageProxyPopupFactory getPopupFactory() {
        return this._popupFactory;
    }

    public ImageProxy<?> getCurrentImage() {
        return this._imageProxy;
    }

    public JButton getWorkflowHistoryButton() {
        return this._workflowHistoryButton;
    }

    public JFrame getParentFrame() {
        return this._parentFrame;
    }

    private static void setToolbarIcon(JButton jButton, String string) {
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(string);
        if (inputStream == null) {
            logger.warn((Object)"unable to load image {}", (Object)string);
        } else {
            ImageIcon imageIcon = new ImageIcon(IOHelper.readFully((InputStream)inputStream));
            jButton.setToolTipText(jButton.getText());
            jButton.setText("");
            jButton.setIcon(imageIcon);
        }
        jButton.setFocusable(false);
    }
}

