/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing.imageviewer;

import com.google.inject.Inject;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import net.model3.guice.DependencyInjector;
import net.model3.imaging.BufferedImageProxy;
import net.model3.imaging.ImageProxy;
import net.model3.imaging.ImageProxyContainer;
import net.model3.imaging.Rotation;
import net.model3.imaging.Size;
import net.model3.lang.ThreadScheduler;
import net.model3.newfile.File;
import net.model3x.swing.imageviewer.ImageReaderWriter;

public abstract class DownloadableImageProxy<T>
implements ImageProxy<T> {
    private static final Executor _backgroundImageDownloadExecutor = Executors.newSingleThreadExecutor();
    public static final BufferedImageProxy<Void> _imageNotFoundImageProxy;
    public static final BufferedImageProxy<Void> _imageNotUploadedImageProxy;
    public static final BufferedImageProxy<Void> _imageDownloadingImageProxy;
    boolean _downloadAttempted = false;
    File _imageFile;
    DownloadManager _transferStateManager = new DownloadManager();
    ImageProxyContainer _imageProxyContainer;
    BufferedImageProxy<T> _bufferedImageProxy;
    String _uuid;
    T _delegate;
    ImageProxy<?> _delegateImageProxy;
    @Inject
    ThreadScheduler _threadScheduler;
    @Inject
    ImageReaderWriter _imageReaderWriter;

    public DownloadableImageProxy() {
        DependencyInjector.inject((Object)this);
    }

    private static BufferedImageProxy<Void> loadImageProxy(String string) {
        ImageProxyContainer imageProxyContainer = (ImageProxyContainer)DependencyInjector.getInstance(ImageProxyContainer.class);
        URL uRL = Thread.currentThread().getContextClassLoader().getResource("_" + string + ".jpg");
        BufferedImageProxy bufferedImageProxy = new BufferedImageProxy(uRL, string, "", null);
        bufferedImageProxy.setKeepImageInMemory(true);
        bufferedImageProxy.setImageImageProxyContainer(imageProxyContainer);
        return bufferedImageProxy;
    }

    protected void init(File file, BufferedImageProxy<T> bufferedImageProxy) {
        this._imageFile = file;
        this._uuid = bufferedImageProxy.getUuid();
        this._delegate = bufferedImageProxy.getDelegate();
        this._bufferedImageProxy = bufferedImageProxy;
        if (this._imageProxyContainer != null) {
            this._bufferedImageProxy.setImageImageProxyContainer(this._imageProxyContainer);
        }
        this.resetState();
    }

    private void resetState() {
        TransferState transferState = this.isImageDownloaded() ? this._transferStateManager.GotIt : (!this.isUploaded() ? this._transferStateManager.NotUploadedYet : (this._downloadAttempted ? this._transferStateManager.ImageNotFound : this._transferStateManager.Downloading));
        if (this._transferStateManager._currentState != transferState) {
            this._transferStateManager.setCurrentState(transferState);
            this.notifyListeners();
        }
    }

    private void notifyListeners() {
        this.getImageProxyContainer().fireImageChanged((ImageProxy)this);
    }

    void scheduleDownload() {
        if (!this.isImageDownloaded()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (!DownloadableImageProxy.this.isImageDownloaded()) {
                        DownloadableImageProxy.this.doDownload();
                        DownloadableImageProxy.this._downloadAttempted = true;
                    }
                    DownloadableImageProxy.this.resetState();
                }
            };
            _backgroundImageDownloadExecutor.execute(runnable);
        }
    }

    public BufferedImage getImage(Size size) {
        return this._delegateImageProxy.getImage(size);
    }

    public BufferedImage getImage(Size size, Rotation rotation) {
        return this._delegateImageProxy.getImage(size, rotation);
    }

    public Size getImageSize() {
        return this._delegateImageProxy.getImageSize();
    }

    public boolean getPreserveAspectRatio() {
        return this._delegateImageProxy.getPreserveAspectRatio();
    }

    public T getDelegate() {
        return this._delegate;
    }

    public final BufferedImage getImage() {
        return this._delegateImageProxy.getImage();
    }

    public String getUuid() {
        return this._uuid;
    }

    public String getQualifiedName() {
        return this.getUuid();
    }

    public boolean isImageDownloaded() {
        return this._imageFile.exists();
    }

    public ImageProxyContainer getImageProxyContainer() {
        return this._imageProxyContainer;
    }

    public void setImageProxyContainer(ImageProxyContainer imageProxyContainer) {
        this._imageProxyContainer = imageProxyContainer;
        if (this._bufferedImageProxy != null) {
            this._bufferedImageProxy.setImageImageProxyContainer(this._imageProxyContainer);
        }
    }

    public abstract boolean isUploaded();

    public abstract void setRotation(Rotation var1);

    public abstract void doDownload();

    public abstract Rotation getRotation();

    static {
        _backgroundImageDownloadExecutor.execute(new Runnable(){

            @Override
            public void run() {
                Thread thread = Thread.currentThread();
                thread.setName("thumbnail-downloader-" + thread.getId());
            }
        });
        _imageNotFoundImageProxy = DownloadableImageProxy.loadImageProxy("image-not-found");
        _imageNotUploadedImageProxy = DownloadableImageProxy.loadImageProxy("image-not-uploaded-yet");
        _imageDownloadingImageProxy = DownloadableImageProxy.loadImageProxy("image-is-downloading");
    }

    class DownloadManager {
        TransferState GotIt = new TransferState(){

            @Override
            void activate() {
                DownloadableImageProxy.this._delegateImageProxy = DownloadableImageProxy.this._bufferedImageProxy;
            }
        };
        TransferState ImageNotFound = new TransferState(){

            @Override
            void activate() {
                DownloadableImageProxy.this._delegateImageProxy = _imageNotFoundImageProxy;
            }
        };
        TransferState Downloading = new TransferState(){

            @Override
            void activate() {
                DownloadableImageProxy.this._delegateImageProxy = _imageDownloadingImageProxy;
                DownloadableImageProxy.this.scheduleDownload();
            }
        };
        TransferState NotUploadedYet = new TransferState(){

            @Override
            void activate() {
                DownloadableImageProxy.this._delegateImageProxy = _imageNotUploadedImageProxy;
            }
        };
        TransferState _currentState;

        DownloadManager() {
        }

        public void setCurrentState(TransferState transferState) {
            this._currentState = transferState;
            this._currentState.activate();
        }
    }

    abstract class TransferState {
        TransferState() {
        }

        abstract void activate();
    }
}

