/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing.domviewer;

import css.component.ComponentWrapper;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JLayeredPane;
import net.model3.bean.converters.Converter;
import net.model3.bean.converters.ConverterAdapter;
import net.model3.collections.SetX;
import net.model3.lang.ClassX;
import net.model3.lang.ObjectX;
import net.model3.lang.StringX;
import net.model3.lang.SystemX;
import net.model3.util.StringJoiner;
import net.model3x.swing.M3Layout;
import net.model3x.swing.domviewer.ComponentPropertyGetter;
import net.model3x.swing.domviewer.ComponentPropertyGetterSetter;

public class PropertyFactory {
    public Map<String, ComponentPropertyGetter> _properties = new LinkedHashMap<String, ComponentPropertyGetter>();

    public PropertyFactory() {
        this._properties.put("name", new ComponentPropertyGetter(){

            @Override
            public String getImpl(Component component, ComponentWrapper componentWrapper) {
                return component.getName();
            }
        });
        this._properties.put("layout", new ComponentPropertyGetter(){

            @Override
            public String getImpl(Component component, ComponentWrapper componentWrapper) {
                LayoutManager layoutManager = ((Container)component).getLayout();
                if (layoutManager == null) {
                    return "null";
                }
                return ClassX.getShortName(layoutManager.getClass());
            }
        });
        this._properties.put("focus listeners", new ComponentPropertyGetter(){

            @Override
            public String getImpl(Component component, ComponentWrapper componentWrapper) {
                return new StringJoiner((Object[])component.getFocusListeners(), ",", (Converter)new ConverterAdapter<Object>(){

                    public String valueToString(Object object) {
                        return ObjectX.identityToString((Object)object);
                    }
                }).toString();
            }
        });
        this._properties.put("container listeners", new ComponentPropertyGetter(){

            @Override
            public String getImpl(Component component, ComponentWrapper componentWrapper) {
                if (component instanceof Container) {
                    return new StringJoiner((Object[])((Container)component).getContainerListeners(), ",", (Converter)new ConverterAdapter<Object>(){

                        public String valueToString(Object object) {
                            return ObjectX.identityToString((Object)object);
                        }
                    }).toString();
                }
                return null;
            }
        });
        this._properties.put("m3layout layout constraints", new ComponentPropertyGetterSetter(){

            @Override
            public String getImpl(Component component, ComponentWrapper componentWrapper) {
                return PropertyFactory.this.getM3Layout(component).getLayoutConstraints();
            }

            @Override
            public void set(Component component, String string) {
                PropertyFactory.this.getM3Layout(component).setLayoutConstraints(string);
            }
        });
        this._properties.put("m3layout column constraints", new ComponentPropertyGetterSetter(){

            @Override
            public String getImpl(Component component, ComponentWrapper componentWrapper) {
                return PropertyFactory.this.getM3Layout(component).getColumnConstraints();
            }

            @Override
            public void set(Component component, String string) {
                PropertyFactory.this.getM3Layout(component).setColumnConstraints(string);
            }
        });
        this._properties.put("m3layout row constraints", new ComponentPropertyGetterSetter(){

            @Override
            public String getImpl(Component component, ComponentWrapper componentWrapper) {
                return PropertyFactory.this.getM3Layout(component).getRowConstraints();
            }

            @Override
            public void set(Component component, String string) {
                PropertyFactory.this.getM3Layout(component).setRowConstraints(string);
            }
        });
        this._properties.put("style names", new ComponentPropertyGetterSetter(){

            @Override
            public String getImpl(Component component, ComponentWrapper componentWrapper) {
                return StringX.join((Iterable)componentWrapper.getStyleClasses(), (String)",", null);
            }

            @Override
            public void set(Component component, String string) {
                ComponentWrapper componentWrapper = ComponentWrapper.get((Component)component);
                Set set = componentWrapper.getStyleClasses();
                String[] stringArray = string.split(",");
                Set set2 = SetX.create();
                for (String string2 : stringArray) {
                    if (!set.contains(string2 = string2.trim())) {
                        componentWrapper.addStyleClass(string2);
                    }
                    set2.add(string2);
                }
                for (String string3 : componentWrapper.getStyleClasses()) {
                    if (set2.contains(string3)) continue;
                    componentWrapper.removeStyleClass(string3);
                }
            }
        });
        this._properties.put("active styles", new ComponentPropertyGetter(){

            @Override
            public String getImpl(Component component, ComponentWrapper componentWrapper) {
                return componentWrapper.getActiveStyles().toString();
            }
        });
        this._properties.put("attached styles", new ComponentPropertyGetter(){

            @Override
            public String getImpl(Component component, ComponentWrapper componentWrapper) {
                return componentWrapper.getAttachedStyles().toString();
            }
        });
        this._properties.put("m3layout component contraint", new ComponentPropertyGetterSetter(){

            @Override
            public String getImpl(Component component, ComponentWrapper componentWrapper) {
                return PropertyFactory.this.getM3Layout(component.getParent()).getComponentConstraint(component);
            }

            @Override
            public void set(Component component, String string) {
                PropertyFactory.this.getM3Layout(component.getParent()).setComponentConstraint(component, string);
            }
        });
        this._properties.put("visible", new ComponentPropertyGetter(){

            @Override
            public String getImpl(Component component, ComponentWrapper componentWrapper) {
                return "" + component.isVisible();
            }
        });
        this._properties.put("min size", new ComponentPropertyGetter(){

            @Override
            public Object getImpl(Component component, ComponentWrapper componentWrapper) {
                return component.getMinimumSize();
            }
        });
        this._properties.put("max size", new ComponentPropertyGetter(){

            @Override
            public Object getImpl(Component component, ComponentWrapper componentWrapper) {
                return component.getMaximumSize();
            }
        });
        this._properties.put("pref size", new ComponentPropertyGetter(){

            @Override
            public Object getImpl(Component component, ComponentWrapper componentWrapper) {
                return component.getPreferredSize();
            }
        });
        this._properties.put("size", new ComponentPropertyGetter(){

            @Override
            public Object getImpl(Component component, ComponentWrapper componentWrapper) {
                return component.getSize();
            }
        });
        this._properties.put("location", new ComponentPropertyGetter(){

            @Override
            public Object getImpl(Component component, ComponentWrapper componentWrapper) {
                return component.getLocation();
            }
        });
        this._properties.put("locationOnScreen", new ComponentPropertyGetter(){

            @Override
            public Object getImpl(Component component, ComponentWrapper componentWrapper) {
                return component.getLocationOnScreen();
            }
        });
        this._properties.put("identity hash", new ComponentPropertyGetter(){

            @Override
            public String getImpl(Component component, ComponentWrapper componentWrapper) {
                return SystemX.identityToString((Object)component);
            }
        });
        this._properties.put("layer", new ComponentPropertyGetter(){

            @Override
            Object getImpl(Component component, ComponentWrapper componentWrapper) {
                return null;
            }

            @Override
            public String get(Component component, ComponentWrapper componentWrapper) {
                if (component.getParent() != null && component.getParent() instanceof JLayeredPane) {
                    return "" + ((JLayeredPane)component.getParent()).getLayer(component);
                }
                return null;
            }
        });
        this._properties.put("background", new ComponentPropertyGetter(){

            @Override
            Object getImpl(Component component, ComponentWrapper componentWrapper) {
                return component.getBackground();
            }
        });
    }

    M3Layout getM3Layout(Component component) {
        if (component instanceof Container && ((Container)component).getLayout() instanceof M3Layout) {
            return (M3Layout)((Container)component).getLayout();
        }
        return null;
    }
}

