/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing.domviewer;

import css.component.ComponentWrapper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.model3.collections.ListX;
import net.model3.collections.MapX;
import net.model3.guice.DependencyInjector;
import net.model3.lang.Visitor;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.swing.GuiHelper;
import net.model3x.swing.BeanListener;
import net.model3x.swing.GlobalHotkeyManager;
import net.model3x.swing.M3Layout;
import net.model3x.swing.domviewer.ComponentHighlighter;
import net.model3x.swing.domviewer.ComponentPropertyGetter;
import net.model3x.swing.domviewer.ComponentPropertyGetterSetter;
import net.model3x.swing.domviewer.ComponentSelector;
import net.model3x.swing.domviewer.HighlightManager;
import net.model3x.swing.domviewer.NodeUserObject;
import net.model3x.swing.domviewer.PropertyFactory;
import net.model3x.swing.uistate.FrameStateMarshaller;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.AbstractLayerUI;
import org.jdesktop.jxlayer.plaf.LayerUI;

public class ComponentTreeModelBuilder {
    private static final Logger logger = LoggerHelper.getLogger();
    PropertyFactory _propertyFactory = new PropertyFactory();
    DefaultTreeModel _treeModel;
    Map<Window, HighlightManager> _higlightManagerMap = MapX.create();
    boolean _showAllWindows;
    Component _defaultComponent;
    JTree _tree = new JTree();
    Map<Component, TreeNode> _componentToTreeNodeMap = MapX.create();
    List<ComponentSelector> _activatedComponentSelectors = ListX.create();

    public ComponentTreeModelBuilder() {
        this(null, true);
    }

    public ComponentTreeModelBuilder(Component component) {
        this(component, false);
    }

    public ComponentTreeModelBuilder(Component component, boolean bl) {
        this._defaultComponent = component;
        this._showAllWindows = bl;
    }

    public DefaultTreeModel createTreeModel() {
        DefaultMutableTreeNode defaultMutableTreeNode;
        this._componentToTreeNodeMap.clear();
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("root");
        if (this._defaultComponent != null) {
            defaultMutableTreeNode = new DefaultMutableTreeNode("default component");
            defaultMutableTreeNode.add(this.createNodeTree(this._defaultComponent));
            defaultMutableTreeNode2.add(defaultMutableTreeNode);
        }
        if (this._showAllWindows) {
            defaultMutableTreeNode = new DefaultMutableTreeNode("All Windows");
            for (Window window : Window.getWindows()) {
                if (!window.isVisible()) continue;
                if (this._defaultComponent == null) {
                    defaultMutableTreeNode2.add(this.createNodeTree(window));
                    continue;
                }
                defaultMutableTreeNode.add(this.createNodeTree(window));
            }
            if (this._defaultComponent != null) {
                defaultMutableTreeNode2.add(defaultMutableTreeNode);
            }
        }
        this._treeModel = new DefaultTreeModel(defaultMutableTreeNode2);
        return this._treeModel;
    }

    DefaultMutableTreeNode createNodeTree(Component component) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.createSingleNode(component);
        this.addChildren(defaultMutableTreeNode, component);
        return defaultMutableTreeNode;
    }

    void addChildren(final DefaultMutableTreeNode defaultMutableTreeNode, Component component) {
        GuiHelper.visitDirectDescendantsOnly((Component)component, (Visitor)new Visitor<JComponent>(){

            public void visit(JComponent jComponent) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = ComponentTreeModelBuilder.this.createSingleNode(jComponent);
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
                ComponentTreeModelBuilder.this.addChildren(defaultMutableTreeNode2, jComponent);
            }
        });
    }

    DefaultMutableTreeNode createSingleNode(Component component) {
        NodeUserObject nodeUserObject = new NodeUserObject(component);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        defaultMutableTreeNode.setUserObject(nodeUserObject);
        this._componentToTreeNodeMap.put(component, defaultMutableTreeNode);
        return defaultMutableTreeNode;
    }

    public void showInFrame() {
        JSplitPane jSplitPane = new JSplitPane(1);
        jSplitPane.add(new JScrollPane(this._tree));
        JFrame jFrame = new JFrame();
        final JPanel jPanel = new JPanel((LayoutManager)new M3Layout());
        jSplitPane.add(new JScrollPane(jPanel));
        jSplitPane.setDividerLocation(400);
        this._tree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                DefaultMutableTreeNode defaultMutableTreeNode;
                TreePath treePath = ComponentTreeModelBuilder.this._tree.getSelectionPath();
                if (treePath != null && (defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject() instanceof NodeUserObject) {
                    NodeUserObject nodeUserObject = (NodeUserObject)defaultMutableTreeNode.getUserObject();
                    Component component = nodeUserObject._component;
                    jPanel.removeAll();
                    jPanel.add(ComponentTreeModelBuilder.this.createPropertyPanel(component));
                    GuiHelper.doLayoutHack((Component)jPanel);
                    ComponentTreeModelBuilder.this.getHighlightManager(component).setHighlightedComponent(component);
                }
            }
        });
        this._tree.setSize(400, 600);
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                for (HighlightManager highlightManager : ComponentTreeModelBuilder.this._higlightManagerMap.values()) {
                    highlightManager.dispose();
                }
            }
        });
        jFrame.getContentPane().setLayout(new BorderLayout());
        JXLayer jXLayer = new JXLayer((Component)jSplitPane);
        jXLayer.setUI((LayerUI)new AbstractLayerUI<JComponent>(){

            protected void processKeyEvent(KeyEvent keyEvent, JXLayer<? extends JComponent> jXLayer) {
                if (keyEvent.getKeyCode() == 116 && keyEvent.getID() == 401) {
                    ComponentTreeModelBuilder.this.refreshComponentTree();
                }
            }
        });
        jFrame.getContentPane().add((Component)jXLayer, "Center");
        jFrame.setName("ComponentTreeViewer");
        ((FrameStateMarshaller)DependencyInjector.getInstance(FrameStateMarshaller.class)).attach(jFrame);
        jFrame.setJMenuBar(this.createMenuBar());
        this.refreshComponentTree();
        jFrame.pack();
        jFrame.setSize(1000, 600);
        jFrame.setVisible(true);
    }

    JPanel createPropertyPanel(final Component component) {
        JPanel jPanel = new JPanel((LayoutManager)new M3Layout());
        ComponentWrapper componentWrapper = null;
        try {
            componentWrapper = ComponentWrapper.get((Component)component);
        }
        catch (Exception exception) {
            // empty catch block
        }
        final List list = ListX.create();
        for (Map.Entry<String, ComponentPropertyGetter> entry : this._propertyFactory._properties.entrySet()) {
            try {
                String string = entry.getValue().get(component, componentWrapper);
                jPanel.add((Component)new JLabel(entry.getKey() + ":"), "right");
                if (entry.getValue() instanceof ComponentPropertyGetterSetter) {
                    Binding binding = new Binding();
                    list.add(binding);
                    binding._component = component;
                    binding._wrapper = componentWrapper;
                    binding._originalValue = string;
                    binding._setter = (ComponentPropertyGetterSetter)entry.getValue();
                    binding._textField.setText(string);
                    jPanel.add((Component)binding._textField, "wrap");
                    continue;
                }
                jPanel.add((Component)new JLabel(string), "wrap");
            }
            catch (Exception exception) {}
        }
        JButton jButton = new JButton("save");
        jPanel.add(jButton);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (Binding binding : list) {
                    binding.bind();
                }
                ComponentTreeModelBuilder.this.getHighlightManager((Component)component)._componentHighlighter.repaint();
            }
        });
        return jPanel;
    }

    private JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("View");
        jMenuBar.add(jMenu);
        AbstractButton abstractButton = null;
        ButtonGroup buttonGroup = new ButtonGroup();
        Object object = ComponentHighlighter.HighlightingMode.values();
        int n = ((ComponentHighlighter.HighlightingMode[])object).length;
        for (int i = 0; i < n; ++i) {
            ComponentHighlighter.HighlightingMode highlightingMode;
            final ComponentHighlighter.HighlightingMode highlightingMode2 = highlightingMode = object[i];
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(highlightingMode.name());
            jRadioButtonMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    for (HighlightManager highlightManager : ComponentTreeModelBuilder.this._higlightManagerMap.values()) {
                        highlightManager.getComponentHighlighter()._mode = highlightingMode2;
                        highlightManager._componentHighlighter.repaint();
                    }
                }
            });
            if (highlightingMode2 == ComponentHighlighter.HighlightingMode.ComponentAndDirectDescendants) {
                abstractButton = jRadioButtonMenuItem;
            }
            jMenu.add(jRadioButtonMenuItem);
            buttonGroup.add(jRadioButtonMenuItem);
        }
        abstractButton.setSelected(true);
        jMenu.addSeparator();
        object = new JMenuItem("Refresh (F5)");
        jMenu.add((JMenuItem)object);
        ((AbstractButton)object).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ComponentTreeModelBuilder.this.refreshComponentTree();
            }
        });
        object = new JMenuItem("Active Component Selector");
        jMenu.add((JMenuItem)object);
        ((AbstractButton)object).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ComponentTreeModelBuilder.this.activateComponentSelector();
            }
        });
        return jMenuBar;
    }

    public void selectComponent(Component component) {
        this.deactivateComponentSelector();
        TreeNode treeNode = this._componentToTreeNodeMap.get(component);
        if (treeNode != null) {
            TreePath treePath = this.convertToTreePath(treeNode);
            this._tree.setSelectionPath(treePath);
            this._tree.expandPath(treePath);
        }
    }

    TreePath convertToTreePath(TreeNode treeNode) {
        List list = ListX.create();
        while (treeNode != null) {
            list.add(treeNode);
            treeNode = treeNode.getParent();
        }
        Collections.reverse(list);
        return new TreePath(list.toArray());
    }

    private void deactivateComponentSelector() {
        for (ComponentSelector componentSelector : this._activatedComponentSelectors) {
            componentSelector.deactivate();
        }
        this._activatedComponentSelectors.clear();
    }

    private void activateComponentSelector() {
        this.deactivateComponentSelector();
        BeanListener<Component> beanListener = new BeanListener<Component>(){

            public void beanEvent(Component component) {
                ComponentTreeModelBuilder.this.selectComponent(component);
            }
        };
        for (Window window : Window.getWindows()) {
            if (!(window instanceof RootPaneContainer)) continue;
            this._activatedComponentSelectors.add(new ComponentSelector(window, beanListener));
        }
    }

    ComponentWrapper getWrapper(Component component) {
        try {
            return ComponentWrapper.get((Component)component);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void refreshComponentTree() {
        logger.debug((Object)"refreshing component tree");
        this._tree.setModel(this.createTreeModel());
    }

    HighlightManager getHighlightManager(Component component) {
        Window window = GuiHelper.getWindowAncestor((Component)component);
        HighlightManager highlightManager = this._higlightManagerMap.get(window);
        if (highlightManager == null) {
            highlightManager = new HighlightManager(window);
            this._higlightManagerMap.put(window, highlightManager);
        }
        return highlightManager;
    }

    public static void addFrameMenu(Component component) {
        Frame frame = (Frame)SwingUtilities.getRoot(component);
        ComponentTreeModelBuilder.addJFrameMenu(frame, component, false);
    }

    public static void addFrameMenus() {
        for (Frame frame : Frame.getFrames()) {
            ComponentTreeModelBuilder.addJFrameMenu(frame, null, true);
        }
    }

    private static void addJFrameMenu(Frame frame, final Component component, final boolean bl) {
        MenuBar menuBar = frame.getMenuBar();
        if (menuBar == null) {
            menuBar = new MenuBar();
            frame.setMenuBar(menuBar);
        }
        Menu menu = new Menu("Tools");
        menuBar.add(menu);
        MenuItem menuItem = new MenuItem("Swing Dom Viewer");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new ComponentTreeModelBuilder(component, bl).showInFrame();
            }
        });
        menu.add(menuItem);
    }

    public static JFrame createFrame(JComponent jComponent) {
        JFrame jFrame = GuiHelper.createFrame((JComponent)jComponent);
        ComponentTreeModelBuilder.addJFrameMenu(jFrame, jComponent, false);
        return jFrame;
    }

    public static void registerHotkey() {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(68, 10, false);
        GlobalHotkeyManager.getInstance().addHotKey(keyStroke, "InvokeDomViewer", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Component component = null;
                if (actionEvent.getSource() instanceof Component) {
                    component = (Component)actionEvent.getSource();
                }
                new ComponentTreeModelBuilder(component, true).showInFrame();
            }
        });
    }

    class Binding {
        Component _component;
        ComponentWrapper _wrapper;
        ComponentPropertyGetterSetter _setter;
        JTextField _textField = new JTextField(100);
        String _originalValue;

        Binding() {
        }

        void bind() {
            String string = this._textField.getText();
            if (this._originalValue != null && !this._originalValue.equals(string) || this._originalValue == null && string.length() > 0) {
                this._setter.set(this._component, string);
                this._originalValue = this._setter.get(this._component, this._wrapper);
                this._textField.setText(this._originalValue);
            }
        }
    }
}

