/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing.domviewer;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import net.model3x.swing.BeanListener;
import net.model3x.swing.domviewer.ComponentHighlighter;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.AbstractLayerUI;
import org.jdesktop.jxlayer.plaf.LayerUI;

public class ComponentSelector {
    Window _window;
    RootPaneContainer _rootPaneContainer;
    JXLayer<JPanel> _inputInterceptor;
    BeanListener<Component> _selectionCallback;

    public ComponentSelector(Window window, BeanListener<Component> beanListener) {
        this._window = window;
        this._selectionCallback = beanListener;
        this._rootPaneContainer = (RootPaneContainer)((Object)window);
        this._inputInterceptor = new JXLayer((Component)new JPanel(){
            {
                this.setOpaque(false);
            }
        });
        this._inputInterceptor.setBounds(new Rectangle(0, 0, this._window.getWidth(), this._window.getHeight()));
        this._rootPaneContainer.getLayeredPane().add((Component)this._inputInterceptor);
        this._rootPaneContainer.getLayeredPane().setLayer((Component)this._inputInterceptor, JLayeredPane.DRAG_LAYER + 500);
        AbstractLayerUI<JPanel> abstractLayerUI = new AbstractLayerUI<JPanel>(){

            public void eventDispatched(AWTEvent aWTEvent, JXLayer<? extends JPanel> jXLayer) {
                if (aWTEvent.getID() == 501) {
                    ComponentSelector.this.selectComponent((MouseEvent)aWTEvent);
                    ((MouseEvent)aWTEvent).consume();
                } else {
                    super.eventDispatched(aWTEvent, jXLayer);
                }
            }
        };
        this._inputInterceptor.setUI((LayerUI)abstractLayerUI);
    }

    void selectComponent(MouseEvent mouseEvent) {
        this.deactivate();
        Point point = mouseEvent.getLocationOnScreen();
        Point point2 = this._window.getLocationOnScreen();
        int n = point.x - point2.x;
        int n2 = point.y - point2.y;
        Component component = SwingUtilities.getDeepestComponentAt(this._window, n, n2);
        if (component instanceof ComponentHighlighter) {
            Component component2 = component;
            component2.setVisible(false);
            component = SwingUtilities.getDeepestComponentAt(this._window, n, n2);
            component2.setVisible(true);
        }
        this._selectionCallback.beanEvent((Object)component);
    }

    public void deactivate() {
        this._rootPaneContainer.getLayeredPane().remove((Component)this._inputInterceptor);
    }
}

