/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing.domviewer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import net.model3.collections.ListX;
import net.model3.collections.SetX;

public class ComponentHighlighter
extends JComponent {
    Set<Component> _components = SetX.create();
    List<Color> _colors = ListX.create((Object[])new Color[]{Color.cyan, Color.black, Color.white});
    Point _locationOnScreen;
    HighlightingMode _mode = HighlightingMode.ComponentAndDirectDescendants;
    JLayeredPane _parent;

    public ComponentHighlighter() {
    }

    public ComponentHighlighter(final JLayeredPane jLayeredPane) {
        this._parent = jLayeredPane;
        jLayeredPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                ComponentHighlighter.this.setSize(jLayeredPane.getSize());
                ComponentHighlighter.this.repaint();
            }
        });
        this.setSize(jLayeredPane.getSize());
        jLayeredPane.add(this);
        jLayeredPane.setLayer(this, Integer.MAX_VALUE);
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.getParent().getSize().equals(this.getSize())) {
            this.setSize(this.getParent().getSize());
        }
        this._locationOnScreen = this.getLocationOnScreen();
        Color color = graphics.getColor();
        for (Component component : this._components) {
            this.highlightComponent(graphics, component);
            if (!(component instanceof Container)) continue;
            Container container = (Container)component;
            if (this._mode == HighlightingMode.Component) continue;
            this.highlightDirectDescendants(graphics, container);
        }
        graphics.setColor(color);
    }

    private void highlightDirectDescendants(Graphics graphics, Container container) {
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            this.highlightComponent(graphics, component);
            if (!(component instanceof Container) || this._mode != HighlightingMode.ComponentAndAllDescendants) continue;
            this.highlightDirectDescendants(graphics, (Container)component);
        }
    }

    private void highlightComponent(Graphics graphics, Component component) {
        try {
            for (int i = 0; i < this._colors.size(); ++i) {
                this.drawOnePixelRect(graphics, component, this._colors.get(i), i);
            }
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            // empty catch block
        }
    }

    public void drawOnePixelRect(Graphics graphics, Component component, Color color, int n) {
        Point point = component.getLocationOnScreen();
        int n2 = point.x - this._locationOnScreen.x + n;
        int n3 = point.y - this._locationOnScreen.y + n;
        int n4 = component.getWidth() - 2 * n;
        int n5 = component.getHeight() - 2 * n;
        graphics.setColor(color);
        graphics.drawLine(n2, n3, n2 + n4, n3);
        graphics.drawLine(n2, n3, n2, n3 + n5);
        graphics.drawLine(n2, n3 + n5, n2 + n4, n3 + n5);
        graphics.drawLine(n2 + n4, n3, n2 + n4, n3 + n5);
    }

    public static enum HighlightingMode {
        Component,
        ComponentAndDirectDescendants,
        ComponentAndAllDescendants;

    }
}

