/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing.dnd;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;

public class DropTargetHighlighter
extends JComponent {
    private static final long serialVersionUID = -1597370652391410946L;
    Rectangle _dropTarget;
    JLayeredPane _parent;

    public DropTargetHighlighter(JLayeredPane jLayeredPane) {
        this._parent = jLayeredPane;
        jLayeredPane.add(this);
        jLayeredPane.setLayer(this, Integer.MAX_VALUE);
        this.setSize(jLayeredPane.getSize());
        this.setLocation(0, 0);
    }

    public void setDropTargetRectangle(Rectangle rectangle) {
        this._dropTarget = rectangle;
        this.repaint();
    }

    @Override
    public void paint(Graphics graphics) {
        if (this._dropTarget != null) {
            Color color = graphics.getColor();
            Color[] colorArray = new Color[]{Color.white, Color.black, Color.cyan, Color.BLUE};
            Rectangle rectangle = new Rectangle(this._dropTarget);
            for (int i = 0; i < colorArray.length; ++i) {
                this.drawOnePixelRect(graphics, rectangle, colorArray[i], i);
            }
            graphics.setColor(color);
        }
    }

    public void drawOnePixelRect(Graphics graphics, Rectangle rectangle, Color color, int n) {
        int n2 = rectangle.x - n;
        int n3 = rectangle.y - n;
        int n4 = rectangle.width + 2 * n;
        int n5 = rectangle.height + 2 * n;
        graphics.setColor(color);
        graphics.drawLine(n2, n3, n2 + n4, n3);
        graphics.drawLine(n2, n3, n2, n3 + n5);
        graphics.drawLine(n2, n3 + n5, n2 + n4, n3 + n5);
        graphics.drawLine(n2 + n4, n3, n2 + n4, n3 + n5);
    }

    public static enum HighlightingMode {
        Component,
        ComponentAndDirectDescendants,
        ComponentAndAllDescendants;

    }
}

