/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing.dnd;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import net.model3x.swing.dnd.DragAndDropHelper;
import net.model3x.swing.dnd.DragAndDropManager;
import net.model3x.swing.dnd.DragInitiator;

public class DraggingContext {
    DragInitiator _dragInitiator;
    MouseEvent _sourceEvent;
    DragAndDropManager _dragAndDropManager;
    Component _source;
    Component _dragView;
    Object _bean;
    Point _dragOffset;
    Rectangle _sourceBounds;
    Container _dragLayer;

    public DragInitiator getDragInitiator() {
        return this._dragInitiator;
    }

    public void setDragInitiator(DragInitiator dragInitiator) {
        this._dragInitiator = dragInitiator;
    }

    public DragAndDropManager getDragAndDropManager() {
        return this._dragAndDropManager;
    }

    public void setDragAndDropManager(DragAndDropManager dragAndDropManager) {
        this._dragAndDropManager = dragAndDropManager;
    }

    public Component getSource() {
        return this._source;
    }

    public void setSource(Component component) {
        this._source = component;
        this._sourceBounds = new Rectangle(0, 0, this._source.getWidth(), this._source.getHeight());
        this._dragLayer = SwingUtilities.getRootPane(this._source).getContentPane();
    }

    public MouseEvent getSourceEvent() {
        return this._sourceEvent;
    }

    public void setSourceEvent(MouseEvent mouseEvent) {
        this._sourceEvent = mouseEvent;
        this.setSource(this._sourceEvent.getComponent());
        this._dragOffset = DragAndDropHelper.subtract(mouseEvent.getLocationOnScreen(), this.getSource().getLocationOnScreen());
    }

    public Object getBean() {
        return this._bean;
    }

    public void setBean(Object object) {
        this._bean = object;
    }

    public Point getDragOffset() {
        return this._dragOffset;
    }

    public void setDragOffset(Point point) {
        this._dragOffset = point;
    }

    public Rectangle getSourceBounds() {
        return this._sourceBounds;
    }

    public void setSourceBounds(Rectangle rectangle) {
        this._sourceBounds = rectangle;
        this._dragOffset.x -= this._sourceBounds.x;
        this._dragOffset.y -= this._sourceBounds.y;
    }

    public Component getDragView() {
        return this._dragView;
    }

    public void setDragView(Component component) {
        this._dragView = component;
        this.getRootLayeredPane().add(component);
        this.getRootLayeredPane().setLayer(component, JLayeredPane.DRAG_LAYER);
    }

    public Container getDragLayer() {
        return this._dragLayer;
    }

    public void setDragLayer(Container container) {
        this._dragLayer = container;
    }

    public JLayeredPane getRootLayeredPane() {
        return this.getRootPane().getLayeredPane();
    }

    public JRootPane getRootPane() {
        return SwingUtilities.getRootPane(this.getSource());
    }

    public void endDrag() {
        this.getRootLayeredPane().remove(this._dragView);
        this.getRootLayeredPane().repaint();
    }
}

