/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing.dnd;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3x.swing.dnd.DragAndDropHelper;
import net.model3x.swing.dnd.DragInitiator;
import net.model3x.swing.dnd.DraggingContext;
import net.model3x.swing.dnd.DropHandler;
import net.model3x.swing.dnd.DropTargetHighlighter;

public class DragAndDropManager {
    Logger logger = LoggerHelper.getLogger();
    GraphicsConfiguration _graphicsConfig = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    DraggingContext _draggingContext;
    DropTargetHighlighter _dropTargetHighlighter;
    MouseAdapter _mouseAdapter = new MouseAdapter(){

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (DragAndDropManager.this.isDragging()) {
                DragAndDropManager.this.dragMove(mouseEvent);
            } else {
                DragAndDropManager.this.dragStart(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (DragAndDropManager.this.isDragging()) {
                DragAndDropManager.this.dragEnd(mouseEvent);
            }
        }
    };
    Map<Component, DropHandler> _dropHandlerMap = new WeakHashMap<Component, DropHandler>();
    Map<Component, DragInitiator> _dragInitiatorMap = new WeakHashMap<Component, DragInitiator>();

    public void registerDropHandler(Component component, DropHandler dropHandler) {
        this._dropHandlerMap.put(component, dropHandler);
    }

    public void registerDragInitiator(Component component, DragInitiator dragInitiator) {
        this._dragInitiatorMap.put(component, dragInitiator);
        component.addMouseListener(this._mouseAdapter);
        component.addMouseMotionListener(this._mouseAdapter);
    }

    public void dragStart(MouseEvent mouseEvent) {
        Component component = (Component)mouseEvent.getSource();
        DragInitiator dragInitiator = this._dragInitiatorMap.get(component);
        if (dragInitiator != null) {
            DraggingContext draggingContext = new DraggingContext();
            draggingContext.setDragAndDropManager(this);
            draggingContext.setSourceEvent(mouseEvent);
            draggingContext.setDragInitiator(dragInitiator);
            if (dragInitiator.startDrag(draggingContext, mouseEvent)) {
                this._draggingContext = draggingContext;
                this.logger.debug((Object)"dragging started");
                Rectangle rectangle = this._draggingContext.getSourceBounds();
                BufferedImage bufferedImage = this._graphicsConfig.createCompatibleImage(rectangle.width, rectangle.height, 3);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.setComposite(AlphaComposite.SrcOver.derive(0.5f));
                graphics2D.translate(-this._draggingContext.getSourceBounds().x, -this._draggingContext.getSourceBounds().y);
                this._draggingContext.getSource().paint(graphics2D);
                JLabel jLabel = new JLabel(new ImageIcon(bufferedImage));
                this._draggingContext.setDragView(jLabel);
                jLabel.setSize(bufferedImage.getWidth(), bufferedImage.getHeight());
                this._dropTargetHighlighter = new DropTargetHighlighter(this._draggingContext.getRootLayeredPane());
                this.dragMove(mouseEvent);
            }
        }
    }

    public void dragMove(MouseEvent mouseEvent) {
        if (this._draggingContext != null) {
            Point point = this._draggingContext.getRootLayeredPane().getLocationOnScreen();
            Point point2 = mouseEvent.getLocationOnScreen();
            Point point3 = DragAndDropHelper.subtract(point2, point);
            point3 = DragAndDropHelper.subtract(point3, this._draggingContext.getDragOffset());
            this._draggingContext.getDragView().setLocation(point3);
            Point point4 = DragAndDropHelper.subtract(mouseEvent.getLocationOnScreen(), this._draggingContext.getDragLayer().getLocationOnScreen());
            Component component = SwingUtilities.getDeepestComponentAt(this._draggingContext.getDragLayer(), point4.x, point4.y);
            DropHandler dropHandler = null;
            if (component != null) {
                dropHandler = this._dropHandlerMap.get(component);
            }
            Rectangle rectangle = null;
            if (dropHandler != null) {
                rectangle = dropHandler.dropAllowed(this._draggingContext, component, mouseEvent);
            }
            if (rectangle != null) {
                Point point5 = DragAndDropHelper.subtract(component.getLocationOnScreen(), this._draggingContext.getRootLayeredPane().getLocationOnScreen());
                rectangle.x += point5.x;
                rectangle.y += point5.y;
            }
            this._dropTargetHighlighter.setDropTargetRectangle(rectangle);
        }
    }

    public void dragEnd(MouseEvent mouseEvent) {
        if (this._draggingContext != null) {
            JRootPane jRootPane = SwingUtilities.getRootPane(this._draggingContext.getSource());
            Container container = jRootPane.getContentPane();
            Point point = DragAndDropHelper.subtract(mouseEvent.getLocationOnScreen(), container.getLocationOnScreen());
            Component component = SwingUtilities.getDeepestComponentAt(container, point.x, point.y);
            DropHandler dropHandler = null;
            if (component != null) {
                dropHandler = this._dropHandlerMap.get(component);
            }
            boolean bl = false;
            if (dropHandler != null) {
                try {
                    if (dropHandler.dropAllowed(this._draggingContext, component, mouseEvent) != null) {
                        bl = dropHandler.doDrop(this._draggingContext, mouseEvent);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this._draggingContext.getRootLayeredPane().remove(this._dropTargetHighlighter);
            this._draggingContext.getDragInitiator().dragCompleted(this._draggingContext, bl);
            this._draggingContext.endDrag();
            this._draggingContext = null;
        }
    }

    public boolean isDragging() {
        return this._draggingContext != null;
    }
}

