/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing.datechooser;

import com.google.inject.Inject;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.net.URL;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.model3.chrono.DateOnly;
import net.model3.guice.DependencyInjector;
import net.model3.lang.ClassX;
import net.model3.lang.StringX;
import net.model3.util.UberDateParser;
import net.model3x.swing.HStringProvider;
import net.model3x.swing.M3Layout;
import net.model3x.swing.PopupBuilder;
import net.model3x.swing.datechooser.DateChooserPanel;
import net.model3x.swing.datechooser.Model;

public class TextFieldDateOnlyChooser
extends JComponent
implements ActionListener {
    private static final long serialVersionUID = 1L;
    DateChooserPanel _dateChooserPanel = new DateChooserPanel();
    JTextField _dateTextField = new JTextField(10);
    JButton _showChooserButton;
    PopupBuilder _builder;
    String _valueText = "";
    DateOnly _value;
    boolean _validValue;
    @Inject
    HStringProvider _stringProvider;
    @Inject
    UberDateParser _dateParser;
    boolean _skipTextFieldParsing = false;

    public TextFieldDateOnlyChooser() {
        DependencyInjector.inject((Object)this);
        this.init();
        this._builder.getPopup().addExcludedComponent((Component)this._dateChooserPanel.getMonthCombo().getPopup());
        this._builder.getPopup().addExcludedComponent((Component)this._dateChooserPanel.getYearCombo().getPopup());
    }

    private void init() {
        this.setLayout((LayoutManager)new M3Layout("insets 0", "[grow][]"));
        URL uRL = ClassX.getResource((String)"JDateChooserIcon.gif");
        ImageIcon imageIcon = new ImageIcon(uRL);
        this._showChooserButton = new JButton(imageIcon);
        this._showChooserButton.setFocusable(false);
        this._showChooserButton.setMargin(new Insets(0, 0, 0, 0));
        this._showChooserButton.addActionListener(this);
        this._builder = new PopupBuilder(this._showChooserButton);
        this.add((Component)this._dateTextField, "growx");
        this.add(this._showChooserButton);
        final Model model = this._dateChooserPanel.getCalendarPanel().getModel();
        this._dateChooserPanel.getCalendarPanel().getModel().getObservable().addObserver(new Observer(){

            @Override
            public void update(Observable observable, Object object) {
                if (model.getSelectedDates().size() > 0) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TextFieldDateOnlyChooser.this.setValueAndReturnFocus(model.getSelectedDates().iterator().next());
                        }
                    });
                    TextFieldDateOnlyChooser.this._builder.hidePopup();
                }
            }
        });
        this._dateTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (focusEvent.getOppositeComponent() != null && TextFieldDateOnlyChooser.this.isValidValue()) {
                    TextFieldDateOnlyChooser.this.setValue(TextFieldDateOnlyChooser.this.getValue(), true);
                }
            }
        });
        this._dateTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.parseTextField();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.parseTextField();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.parseTextField();
            }

            void parseTextField() {
                if (!TextFieldDateOnlyChooser.this._skipTextFieldParsing) {
                    TextFieldDateOnlyChooser.this.setValueText(TextFieldDateOnlyChooser.this._dateTextField.getText(), true, false);
                }
            }
        });
        this._builder.getPopup().add((Component)this._dateChooserPanel);
    }

    public DateOnly getValue() {
        return this._value;
    }

    public void setValue(DateOnly dateOnly) {
        this.setValue(dateOnly, true);
    }

    public void setValueAndReturnFocus(DateOnly dateOnly) {
        this.setValue(dateOnly, true);
        this._dateTextField.grabFocus();
    }

    public void setValue(DateOnly dateOnly, boolean bl) {
        DateOnly dateOnly2 = this._value;
        this._value = dateOnly;
        if (bl) {
            this.setValueText(this._stringProvider.toString(this._value), false, true);
            this.setValidValue(true);
        }
        this.firePropertyChange("value", dateOnly2, this._value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValueText(String string, boolean bl, boolean bl2) {
        String string2 = this._valueText;
        if (string2.equals(string)) {
            return;
        }
        this._valueText = string;
        if (bl2) {
            boolean bl3 = this._skipTextFieldParsing;
            try {
                this._skipTextFieldParsing = true;
                this._dateTextField.setText(this._valueText);
            }
            finally {
                this._skipTextFieldParsing = bl3;
            }
        }
        this.firePropertyChange("valueText", string2, this._valueText);
        if (bl) {
            DateOnly dateOnly = this._dateParser.parseDateOnly(this._valueText);
            this.setValidValue(StringX.isBlank((String)this._valueText) || dateOnly != null);
            this.setValue(dateOnly, false);
        }
    }

    public boolean isValidValue() {
        return this._validValue;
    }

    public void setValidValue(boolean bl) {
        boolean bl2 = this._validValue;
        this._validValue = bl;
        this.firePropertyChange("validValue", bl2, this._validValue);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Dimension dimension = this._dateChooserPanel.getPreferredSize();
        DateOnly dateOnly = this.getValue();
        if (dateOnly == null) {
            dateOnly = new DateOnly();
            this._dateChooserPanel.setValue((DateOnly)null);
        } else {
            this._dateChooserPanel.setValue(this.getValue());
        }
        this._dateChooserPanel.setViewMonth(dateOnly);
        int n = this._showChooserButton.getLocationOnScreen().x - dimension.width;
        int n2 = this._showChooserButton.getLocationOnScreen().y + this._showChooserButton.getHeight();
        this._builder.showPopup(n, n2, this);
    }
}

