/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing.datechooser;

import java.util.Observable;
import java.util.Set;
import net.model3.chrono.DateOnly;
import net.model3.collections.SetX;
import net.model3x.swing.datechooser.Model;
import net.model3x.swing.datechooser.SelectionMode;

public class ModelImpl
extends Observable
implements Model {
    SelectionMode _selectionMode = SelectionMode.Single;
    Set<DateOnly> _selectedDates = SetX.create();
    boolean _allowNulls;

    @Override
    public boolean isDateSelected(DateOnly dateOnly) {
        return this._selectedDates.contains(dateOnly);
    }

    @Override
    public void addSelectedDate(DateOnly dateOnly, boolean bl) {
        this.addSelectedDates(SetX.create((Object[])new DateOnly[]{dateOnly}), bl);
    }

    @Override
    public void addSelectedDates(Iterable<DateOnly> iterable, boolean bl) {
        if (this._selectionMode != SelectionMode.Multi) {
            bl = false;
        }
        if (!bl) {
            this._selectedDates.clear();
        }
        for (DateOnly dateOnly : iterable) {
            if (this.isSelectable(dateOnly)) {
                this._selectedDates.add(dateOnly);
                if (this._selectionMode == SelectionMode.Single) break;
            }
            dateOnly = dateOnly.addDays(1);
        }
        this.fireModelChangeEvent();
    }

    private void fireModelChangeEvent() {
        this.setChanged();
        this.notifyObservers();
    }

    @Override
    public Set<DateOnly> getSelectedDates() {
        return this._selectedDates;
    }

    @Override
    public void removeSelectedDate(DateOnly dateOnly) {
        if (this.getSelectedDates().contains(dateOnly) && (this.getSelectedDates().size() != 1 || this.allowNulls())) {
            this._selectedDates.remove(dateOnly);
        }
        this.fireModelChangeEvent();
    }

    @Override
    public boolean isSelectable(DateOnly dateOnly) {
        return true;
    }

    @Override
    public Observable getObservable() {
        return this;
    }

    @Override
    public void setSelectionMode(SelectionMode selectionMode) {
        this._selectionMode = selectionMode;
    }

    @Override
    public void setAllowNulls(boolean bl) {
        this._allowNulls = bl;
        if (this.getSelectedDates().size() == 0) {
            this.addSelectedDate(new DateOnly(), false);
        }
    }

    @Override
    public boolean allowNulls() {
        return this._allowNulls;
    }

    @Override
    public void clear() {
        this._selectedDates.clear();
    }
}

