/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing.datechooser;

import com.google.inject.Inject;
import com.jidesoft.popup.JidePopup;
import css.Stylesheet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import net.model3.chrono.DateOnly;
import net.model3.guice.DependencyInjector;
import net.model3.swing.GuiHelper;
import net.model3x.swing.HStringProvider;
import net.model3x.swing.M3Layout;
import net.model3x.swing.PopupBuilder;
import net.model3x.swing.datechooser.DateChooserPanel;
import net.model3x.swing.datechooser.Model;

public class LabelDateOnlyChooser
extends JComponent
implements ActionListener {
    DateChooserPanel _dateChooserPanel = new DateChooserPanel();
    JLabel _dateLabel = new JLabel();
    JButton _showChooserButton;
    PopupBuilder _builder = new PopupBuilder(this._showChooserButton);
    DateOnly _value;
    @Inject
    HStringProvider _hStringProvider;
    @Inject
    Stylesheet _stylesheet;
    HStringProvider.HStringAdapter<DateOnly> _dateFormatter;

    public LabelDateOnlyChooser() {
        DependencyInjector.inject((Object)this);
        this.init();
        this._builder.getPopup().addExcludedComponent((Component)this._dateChooserPanel.getMonthCombo().getPopup());
        this._builder.getPopup().addExcludedComponent((Component)this._dateChooserPanel.getYearCombo().getPopup());
        this.setValue(new DateOnly());
    }

    private void init() {
        this.setLayout((LayoutManager)new M3Layout("insets 0,fill"));
        ImageIcon imageIcon = GuiHelper.loadIcon((String)"JDateChooserIcon.gif");
        this._showChooserButton = new JButton(imageIcon);
        this._showChooserButton.setFocusable(false);
        this._showChooserButton.setMargin(new Insets(0, 0, 0, 0));
        this._showChooserButton.addActionListener(this);
        this.add((Component)this._dateLabel, "growx");
        this.add(this._showChooserButton);
        final Model model = this._dateChooserPanel.getCalendarPanel().getModel();
        this._stylesheet.applyTo((Component)this._dateChooserPanel);
        this._dateChooserPanel.getCalendarPanel().getModel().getObservable().addObserver(new Observer(){

            @Override
            public void update(Observable observable, Object object) {
                if (model.getSelectedDates().size() > 0) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LabelDateOnlyChooser.this.setValue(model.getSelectedDates().iterator().next());
                        }
                    });
                    LabelDateOnlyChooser.this._builder.hidePopup();
                }
            }
        });
        this._builder.getPopup().add((Component)this._dateChooserPanel);
    }

    public DateOnly getValue() {
        return this._value;
    }

    public void setValue(DateOnly dateOnly) {
        DateOnly dateOnly2 = this._value;
        this._value = dateOnly;
        this._dateLabel.setText(this.formatDate(this._value));
        this.firePropertyChange("value", dateOnly2, this._value);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Dimension dimension = this._dateChooserPanel.getPreferredSize();
        DateOnly dateOnly = this.getValue();
        if (dateOnly == null) {
            dateOnly = new DateOnly();
            this._dateChooserPanel.setValue((DateOnly)null);
        } else {
            this._dateChooserPanel.setValue(this.getValue());
        }
        this._dateChooserPanel.setViewMonth(dateOnly);
        int n = this._showChooserButton.getLocationOnScreen().x - dimension.width;
        int n2 = this._showChooserButton.getLocationOnScreen().y + this._showChooserButton.getHeight();
        JidePopup jidePopup = this._builder.getPopup();
        jidePopup.showPopup(n, n2);
    }

    public void setDateFormatter(HStringProvider.HStringAdapter<DateOnly> hStringAdapter) {
        this._dateFormatter = hStringAdapter;
        this._dateLabel.setText(this.formatDate(this._value));
    }

    String formatDate(DateOnly dateOnly) {
        if (this._dateFormatter != null) {
            return this._dateFormatter.valueToString(dateOnly);
        }
        return this._hStringProvider.toString(dateOnly);
    }
}

