/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing.datechooser;

import css.CssHelper;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import net.model3.chrono.DateOnly;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3x.swing.datechooser.CalendarPanel;

public class DayLabel
extends JLabel {
    private static final Logger logger = LoggerHelper.getLogger();
    private static final long serialVersionUID = 1L;
    private final CalendarPanel _dateChooser;
    DateOnly _date;
    boolean _selected = false;
    boolean _today = false;
    State _state = State.Selectable;

    public DayLabel(CalendarPanel calendarPanel) {
        this._dateChooser = calendarPanel;
        this.setName("day");
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                DayLabel.this._dateChooser.mousePressed(DayLabel.this, mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                DayLabel dayLabel = DayLabel.this.getSibling(mouseEvent.getPoint());
                DayLabel.this._dateChooser.mouseReleased(dayLabel, mouseEvent);
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                DayLabel dayLabel = DayLabel.this.getSibling(mouseEvent.getPoint());
                if (dayLabel != null) {
                    DayLabel.this._dateChooser.setDragEnd(dayLabel);
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                if (DayLabel.this._dateChooser.isDragging()) {
                    if ((mouseEvent.getModifiers() & 0x10) > 0) {
                        DayLabel.this._dateChooser.setDragEnd(DayLabel.this);
                    } else {
                        DayLabel.this._dateChooser.abortDragging();
                    }
                } else if (DayLabel.this.isEnabled() && DayLabel.this.isInSelectableState()) {
                    DayLabel.this.setState(State.MouseHover);
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                if (DayLabel.this.isEnabled() && DayLabel.this._state == State.MouseHover) {
                    DayLabel.this.resetToSelectableState();
                }
            }
        };
        this.addMouseListener(mouseAdapter);
        this.addMouseMotionListener(mouseAdapter);
    }

    DayLabel getSibling(Point point) {
        point.x += this.getX();
        point.y += this.getY();
        Component component = this._dateChooser.getComponentAt(point);
        if (component instanceof DayLabel) {
            return (DayLabel)component;
        }
        return null;
    }

    public void setDate(DateOnly dateOnly) {
        this._date = dateOnly;
        this._selected = this._dateChooser._model.isDateSelected(dateOnly);
        this._today = dateOnly.equals((Object)new DateOnly());
        if (!this._dateChooser._model.isSelectable(dateOnly)) {
            this.setState(State.Disabled);
        } else {
            this.resetToSelectableState();
        }
        CssHelper.enableStyleClass((Component)this, (boolean)this._today, (String)"today");
    }

    public void setState(State state) {
        if (state == null) {
            throw new NullPointerException();
        }
        if (this._state != state) {
            State state2 = this._state;
            CssHelper.removeStyleClass((Component)this, (String)state2.name());
            this._state = state;
            CssHelper.addStyleClass((Component)this, (String)this._state.name());
        }
    }

    public boolean isInSelectableState() {
        return this._state == State.BookingFull || this._state == State.BookingOpen || this._state == State.BookingPartial || this._state == State.Selectable || this._state == State.Selected;
    }

    void resetToSelectableState() {
        if (this._selected) {
            this.setState(State.Selected);
        } else {
            State state = this._dateChooser.getBackgroundPainter().getState(this._date);
            if (state == null) {
                state = State.Selectable;
            }
            if (state != this._state) {
                this.setState(state);
            }
        }
    }

    public boolean isDisabled() {
        return this._state == State.Disabled;
    }

    public boolean isSelected() {
        return this._selected;
    }

    static {
        logger.toString();
    }

    public static enum State {
        Disabled,
        Selectable,
        Selected,
        BookingOpen,
        BookingPartial,
        BookingFull,
        MouseHover,
        DragHover;

    }
}

