/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing.datechooser;

import com.jidesoft.swing.JideButton;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JPanel;
import net.model3.chrono.DateOnly;
import net.model3.chrono.Month;
import net.model3x.swing.M3Layout;
import net.model3x.swing.QuickCombo;
import net.model3x.swing.datechooser.CalendarPanel;
import net.model3x.swing.datechooser.SelectionMode;

public class DateChooserPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private CalendarPanel _calendarPanel = new CalendarPanel();
    private QuickCombo _yearCB;
    private QuickCombo _monthCB;
    private JPanel _header;
    private DateOnly _viewMonth;
    int[] _yearsPattern = new int[]{-50, -25, -15, -10, -5, -4, -3, -2, -1, 0, 1, 2, 3, 4, 5};

    public DateChooserPanel() {
        this(new DateOnly());
    }

    public DateChooserPanel(DateOnly dateOnly) {
        this(dateOnly, SelectionMode.Single);
    }

    public DateChooserPanel(DateOnly dateOnly, SelectionMode selectionMode) {
        this._calendarPanel.getModel().setSelectionMode(selectionMode);
        this.init();
        if (dateOnly != null) {
            this.setValue(dateOnly);
            this.setViewMonth(dateOnly);
        } else {
            this.setViewMonth(new DateOnly());
        }
    }

    private void init() {
        this.setLayout((LayoutManager)new M3Layout("insets 0"));
        this._header = new JPanel((LayoutManager)new M3Layout("insets 0,gap 0"));
        JideButton jideButton = new JideButton("<");
        this._header.add((Component)jideButton);
        jideButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DateChooserPanel.this.incrementView(0, -1);
            }
        });
        this._monthCB = new QuickCombo(Month.values());
        this._monthCB.addActionListener(new DateWidgetActionListener());
        this._header.add((Component)this._monthCB, "span 2");
        JideButton jideButton2 = new JideButton(">");
        this._header.add((Component)jideButton2, "gap 0 unrel");
        jideButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DateChooserPanel.this.incrementView(0, 1);
            }
        });
        JideButton jideButton3 = new JideButton("<");
        this._header.add((Component)jideButton3);
        jideButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DateChooserPanel.this.incrementView(-1, 0);
            }
        });
        this._yearCB = new QuickCombo();
        this._yearCB.addActionListener(new DateWidgetActionListener());
        this._header.add(this._yearCB);
        JideButton jideButton4 = new JideButton(">");
        this._header.add((Component)jideButton4);
        jideButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DateChooserPanel.this.incrementView(1, 0);
            }
        });
        this._calendarPanel.getModel().clear();
        this.add((Component)this._header, "alignx 50%,wrap");
        this.add((Component)this._calendarPanel, "span");
    }

    void incrementView(int n, int n2) {
        DateOnly dateOnly = this._viewMonth;
        dateOnly = dateOnly.add(2, n2);
        dateOnly = dateOnly.add(1, n);
        this.setViewMonth(dateOnly);
    }

    public Set<DateOnly> getValue() {
        return this._calendarPanel.getModel().getSelectedDates();
    }

    public void setValue(DateOnly dateOnly) {
        this._calendarPanel.getModel().addSelectedDate(dateOnly, false);
    }

    public CalendarPanel getCalendarPanel() {
        return this._calendarPanel;
    }

    public void setValue(Set<DateOnly> set) {
        this._calendarPanel.getModel().addSelectedDates(set, false);
    }

    public void setViewMonth(DateOnly dateOnly) {
        if (dateOnly == null) {
            dateOnly = new DateOnly();
        }
        DateOnly dateOnly2 = this._viewMonth;
        DateOnly dateOnly3 = dateOnly;
        if (dateOnly3.getDay() != 1) {
            dateOnly3 = new DateOnly(dateOnly.getYear(), dateOnly.getMonth(), 1);
        }
        this._viewMonth = dateOnly3;
        this._monthCB.setSelectedIndex(dateOnly.getMonthIndex());
        this._yearCB.setSelectedItem(dateOnly.getYear());
        this._calendarPanel.setCalendarStartDate(dateOnly);
        if (dateOnly2 == null || dateOnly2.getYear() != dateOnly.getYear()) {
            this.resetYears();
        }
    }

    public int[] getYearsPattern() {
        return this._yearsPattern;
    }

    public void setYearsPattern(int[] nArray) {
        this._yearsPattern = nArray;
    }

    private void resetYears() {
        DefaultComboBoxModel<Integer> defaultComboBoxModel = new DefaultComboBoxModel<Integer>();
        int n = this._viewMonth.getYear();
        for (int n2 : this._yearsPattern) {
            defaultComboBoxModel.addElement(n + n2);
        }
        defaultComboBoxModel.setSelectedItem(this._viewMonth.getYear());
        this._yearCB.setModel(defaultComboBoxModel);
    }

    public QuickCombo getMonthCombo() {
        return this._monthCB;
    }

    public QuickCombo getYearCombo() {
        return this._yearCB;
    }

    private class DateWidgetActionListener
    implements ActionListener {
        private DateWidgetActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Month month = (Month)DateChooserPanel.this._monthCB.getSelectedItem();
            int n = (Integer)DateChooserPanel.this._yearCB.getSelectedItem();
            DateChooserPanel.this.setViewMonth(new DateOnly(n, month, 1));
        }
    }
}

