/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing.datechooser;

import css.CssHelper;
import css.Stylesheet;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import net.model3.chrono.DateOnly;
import net.model3.chrono.DateRange;
import net.model3.chrono.DayOfWeek;
import net.model3.collections.ListX;
import net.model3.collections.MapX;
import net.model3.guice.DependencyInjector;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3x.swing.datechooser.BackgroundPainter;
import net.model3x.swing.datechooser.DayLabel;
import net.model3x.swing.datechooser.Model;
import net.model3x.swing.datechooser.ModelImpl;
import net.model3x.swing.datechooser.SelectionMode;

public class CalendarPanel
extends JPanel {
    private static final Logger logger = LoggerHelper.getLogger();
    private static final long serialVersionUID = 1L;
    int _numberOfWeeksToShow = 6;
    Model _model;
    DateOnly _calendarStartDate;
    List<DayOfWeek> _daysOfWeek;
    List<JLabel> _northHeader = ListX.create();
    List<List<DayLabel>> _weeks = ListX.create();
    JLabel _upperLeftCorner;
    Map<DateOnly, DayLabel> _dateToLabelMap = MapX.create();
    DayLabel _dragStart;
    DayLabel _dragEnd;
    boolean _dragLeftSingleCell;
    boolean _reset = true;
    BackgroundPainter _backgroundPainter = new BackgroundPainter(){

        @Override
        public DayLabel.State getState(DateOnly dateOnly) {
            return null;
        }

        @Override
        public void setCalendarPanel(CalendarPanel calendarPanel) {
        }
    };

    public static Stylesheet getStylesheet() {
        return (Stylesheet)DependencyInjector.getInstance(Stylesheet.class);
    }

    public CalendarPanel(SelectionMode selectionMode) {
        this();
        this._model.setSelectionMode(selectionMode);
    }

    public CalendarPanel() {
        Object object;
        this.setLayout((LayoutManager)new MigLayout("insets 0, gap 0 0"));
        this.setModel(new ModelImpl());
        for (Object object2 : this.getDaysOfWeek()) {
            object = this.createHeaderLabel();
            this._northHeader.add((JLabel)object);
            if (this.isLastDayOfWeek((DayOfWeek)object2)) {
                this.add((Component)object, "wrap");
                continue;
            }
            this.add((Component)object);
        }
        for (int i = 0; i < this._numberOfWeeksToShow; ++i) {
            Object object2;
            object2 = this.createHeaderLabel();
            object = ListX.create();
            this._weeks.add((List<DayLabel>)object);
            for (int j = 0; j < 7; ++j) {
                DayLabel dayLabel = new DayLabel(this);
                object.add(dayLabel);
                String string = "";
                if (j == 6) {
                    string = string + ",wrap";
                }
                this.add((Component)dayLabel, string);
            }
        }
        this.setCalendarStartDate(new DateOnly());
    }

    JLabel createHeaderLabel() {
        JLabel jLabel = new JLabel();
        CssHelper.addStyleClass((Component)jLabel, (String)"DateChooser-header");
        return jLabel;
    }

    public void setFirstDayOfWeek(DayOfWeek dayOfWeek) {
        this.initDaysOfWeek(dayOfWeek);
        this.scheduleReset();
    }

    void resetHeaders() {
        this.resetNorthHeader();
        this.resetWestHeader();
        this.resetDayLabels();
    }

    void resetNorthHeader() {
        int n = 0;
        for (DayOfWeek dayOfWeek : this.getDaysOfWeek()) {
            this._northHeader.get(n).setText(dayOfWeek.getTwoLetterAbbr());
            ++n;
        }
    }

    void resetWestHeader() {
    }

    public void resetDayLabels() {
        DateOnly dateOnly = this._calendarStartDate;
        this._dateToLabelMap.clear();
        for (int i = 0; i < this._numberOfWeeksToShow; ++i) {
            for (DayLabel dayLabel : this._weeks.get(i)) {
                dayLabel.setText("" + dateOnly.getDay());
                dayLabel.setDate(dateOnly);
                this._dateToLabelMap.put(dateOnly, dayLabel);
                dateOnly = dateOnly.addDays(1);
            }
        }
    }

    public DateOnly getCalendarStartDate() {
        return this._calendarStartDate;
    }

    public void setCalendarStartDate(DateOnly dateOnly) {
        this._calendarStartDate = dateOnly = new DateOnly(dateOnly.getYear(), dateOnly.getMonth(), 1);
        while (this._calendarStartDate.getDayOfWeek() != this.getFirstDayInWeek()) {
            this._calendarStartDate = this._calendarStartDate.addDays(-1);
        }
        this.scheduleReset();
    }

    boolean isLastDayOfWeek(DayOfWeek dayOfWeek) {
        return this.getDaysOfWeek().indexOf(dayOfWeek) == 6;
    }

    void initDaysOfWeek(DayOfWeek dayOfWeek) {
        this._daysOfWeek = ListX.create();
        DayOfWeek dayOfWeek2 = dayOfWeek;
        for (int i = 0; i < 7; ++i) {
            this._daysOfWeek.add(dayOfWeek2);
            dayOfWeek2 = dayOfWeek2.nextDay();
        }
    }

    DayOfWeek getFirstDayInWeek() {
        return this.getDaysOfWeek().get(0);
    }

    List<DayOfWeek> getDaysOfWeek() {
        if (this._daysOfWeek == null) {
            this.initDaysOfWeek(DayOfWeek.Sunday);
        }
        return this._daysOfWeek;
    }

    void setDragHover(DateRange dateRange) {
        for (DayLabel dayLabel : this._dateToLabelMap.values()) {
            if (dayLabel.isDisabled()) continue;
            if (dateRange.contains(dayLabel._date)) {
                dayLabel.setState(DayLabel.State.DragHover);
                continue;
            }
            dayLabel.resetToSelectableState();
        }
    }

    void setDragStart(DayLabel dayLabel) {
        this._dragLeftSingleCell = false;
        this._dragEnd = this._dragStart = dayLabel;
    }

    void setDragEnd(DayLabel dayLabel) {
        if (this._dragStart != this._dragEnd) {
            this._dragLeftSingleCell = true;
        }
        this._dragEnd = dayLabel;
        this.setDragHover(new DateRange(this._dragStart._date, this._dragEnd._date));
    }

    void mousePressed(DayLabel dayLabel, MouseEvent mouseEvent) {
        this.setDragStart(dayLabel);
    }

    void mouseReleased(DayLabel dayLabel, MouseEvent mouseEvent) {
        if (dayLabel != null) {
            if (this._dragStart != null && this._dragEnd != null && !this._dragStart.equals(this._dragEnd)) {
                this._model.addSelectedDates(new DateRange(this._dragStart._date, dayLabel._date).asSet(), this.getAdditivity(mouseEvent));
            } else if (this.getAdditivity(mouseEvent)) {
                if (dayLabel.isSelected()) {
                    this._model.removeSelectedDate(dayLabel._date);
                } else {
                    this._model.addSelectedDate(dayLabel._date, true);
                }
            } else {
                this._model.addSelectedDate(dayLabel._date, false);
            }
            this.firePropertyChange("days", 0, 1);
        }
        this.abortDragging();
    }

    boolean getAdditivity(MouseEvent mouseEvent) {
        return (mouseEvent.getModifiers() & 2) > 0;
    }

    void abortDragging() {
        this._dragLeftSingleCell = false;
        this._dragStart = null;
        this._dragEnd = null;
        this.setDragHover(new DateRange());
    }

    boolean isDragging() {
        return this._dragStart != null;
    }

    public BackgroundPainter getBackgroundPainter() {
        return this._backgroundPainter;
    }

    public void setBackgroundPainter(BackgroundPainter backgroundPainter) {
        this._backgroundPainter = backgroundPainter;
        this._backgroundPainter.setCalendarPanel(this);
        this.scheduleReset();
    }

    public Model getModel() {
        return this._model;
    }

    public void setModel(Model model) {
        this._model = model;
        this._model.getObservable().addObserver(new Observer(){

            @Override
            public void update(Observable observable, Object object) {
                CalendarPanel.this.resetDayLabels();
            }
        });
        this.scheduleReset();
    }

    public void scheduleReset() {
        this._reset = true;
        this.repaint();
    }

    @Override
    public void paint(Graphics graphics) {
        if (this._reset) {
            this.resetDayLabels();
            this.resetHeaders();
            this._reset = false;
        }
        super.paint(graphics);
    }

    static {
        logger.toString();
    }
}

