/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing.beanprops.form;

import com.google.inject.Inject;
import java.awt.Component;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import net.java.dev.properties.container.IPropertyContext;
import net.java.dev.properties.container.PropertyContextable;
import net.model3.collections.ListX;
import net.model3.guice.DependencyInjector;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.swing.GuiHelper;
import net.model3x.swing.FocusMonitor;
import net.model3x.swing.beanprops.BeanViewsFactory;
import net.model3x.swing.beanprops.form.FormBuilder;
import net.model3x.swing.beanprops.form.FormContainers;
import net.model3x.swing.beanprops.form.FormDefinition;
import net.model3x.swing.beanprops.form.FormField;
import net.model3x.swing.beanprops.form.FormListener;

public class MultiBeanFormBuilder<T> {
    private static final Logger logger = LoggerHelper.getLogger();
    List<JLabel> _headerLabels = ListX.create();
    Map<T, FormBuilder<T>> _beanToFormBuilderMap = new LinkedHashMap<T, FormBuilder<T>>();
    FormDefinition _formDefinition;
    FormContainers _formContainers = new FormContainers(this);
    Class<T> _type;
    List<FormListener<T>> _formListeners = ListX.create();
    FocusMonitor _focusMonitor;
    @Inject
    BeanViewsFactory _beanViewsFactory;

    public MultiBeanFormBuilder(Class<T> clazz) {
        this._focusMonitor = new FocusMonitor(this._formContainers._form);
        DependencyInjector.inject((Object)this);
        this._type = clazz;
        this._formDefinition = this._beanViewsFactory.getFormDefinition(this._type);
        this.addHeader();
    }

    public MultiBeanFormBuilder(IPropertyContext iPropertyContext) {
        this._focusMonitor = new FocusMonitor(this._formContainers._form);
        DependencyInjector.inject((Object)this);
        this._type = iPropertyContext.getType();
        this._formDefinition = this._beanViewsFactory.getFormDefinition(iPropertyContext);
        this.addHeader();
    }

    public FormDefinition getFormDefinition() {
        return this._formDefinition;
    }

    public void setFormDefinition(FormDefinition formDefinition) {
        this._formDefinition = formDefinition;
    }

    public void addBean(T t) {
        this.addFormBuilder(t);
    }

    public void removeBean(T t) {
        FormBuilder<T> formBuilder = this._beanToFormBuilderMap.get(t);
        if (formBuilder != null) {
            for (FormField formField : formBuilder.getFields()) {
                this._formContainers._fieldsPanel.remove(formField.getEditor().getWidget());
                this._formContainers._iconLayer.remove(formField.getErrorIcon());
            }
            GuiHelper.doLayoutHack((Component)this._formContainers._fieldsPanel, (boolean)true);
        }
    }

    private void addHeader() {
        if (this._headerLabels.size() == 0) {
            for (IPropertyContext iPropertyContext : this._formDefinition.getFields()) {
                JLabel jLabel = new JLabel(iPropertyContext.getDisplayName());
                this._formContainers._fieldsPanel.add(jLabel);
                this._headerLabels.add(jLabel);
            }
            GuiHelper.doLayoutHack((Component)this._formContainers._fieldsPanel, (boolean)true);
        }
    }

    public void clearAllBeans() {
        for (T t : this._beanToFormBuilderMap.keySet()) {
            this.removeBean(t);
        }
        this._beanToFormBuilderMap.clear();
    }

    private void addFormBuilder(T t) {
        FormBuilder<T> formBuilder = new FormBuilder<T>(this._type, this._formContainers);
        for (IPropertyContext object : this._formDefinition.getFields()) {
            formBuilder.addColumn((PropertyContextable)object);
        }
        for (FormListener formListener : this._formListeners) {
            formBuilder.addListener(formListener);
        }
        formBuilder.setInitialized(true);
        formBuilder.setBean(t);
        this._beanToFormBuilderMap.put(t, formBuilder);
        GuiHelper.doLayoutHack((Component)this._formContainers._form, (boolean)true);
    }

    public void addFormListener(FormListener<T> formListener) {
        this._formListeners.add(formListener);
    }

    public void setEnabled(boolean bl) {
        for (FormBuilder<T> object : this._beanToFormBuilderMap.values()) {
            object.setEnabledImpl(bl);
        }
        for (JLabel jLabel : this._headerLabels) {
            jLabel.setEnabled(bl);
        }
    }

    public JComponent getForm() {
        return this._formContainers._form;
    }

    public List<T> getPopulatedBeans() {
        List list = ListX.create();
        for (FormBuilder<T> formBuilder : this._beanToFormBuilderMap.values()) {
            formBuilder.populateBean();
            list.add(formBuilder.getBean());
        }
        return list;
    }

    public List<FormBuilder<T>> getFormBuilders() {
        return ListX.create(this._beanToFormBuilderMap.values());
    }

    public boolean hasChanges() {
        for (FormBuilder<T> formBuilder : this.getFormBuilders()) {
            if (!formBuilder.hasChanges()) continue;
            return true;
        }
        return false;
    }

    public boolean hasErrors() {
        for (FormBuilder<T> formBuilder : this.getFormBuilders()) {
            if (!formBuilder.hasErrors()) continue;
            return true;
        }
        return false;
    }

    static {
        logger.toString();
    }
}

