/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing.beanprops.form;

import com.google.inject.Inject;
import java.util.List;
import java.util.Set;
import javax.swing.JLabel;
import net.java.dev.properties.container.IPropertyContext;
import net.model3.collections.ListX;
import net.model3.collections.SetX;
import net.model3.guice.DependencyInjector;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3x.swing.IconFactory;
import net.model3x.swing.beanprops.editors.AbstractEditor;
import net.model3x.swing.beanprops.editors.Editor;
import net.model3x.swing.beanprops.editors.MegaListener;
import net.model3x.swing.beanprops.editors.MegaListenerAction;
import net.model3x.swing.beanprops.form.ErrorMessage;
import net.model3x.swing.beanprops.form.FormBuilder;
import net.model3x.swing.beanprops.form.FormFieldListener;

public class FormField {
    private static final Logger logger = LoggerHelper.getLogger();
    FormBuilder<?> _formBuilder;
    @Inject
    IconFactory _iconFactory;
    IPropertyContext _property;
    Editor<?> _editor;
    JLabel _label;
    boolean _required;
    JLabel _errorIcon;
    List<ErrorMessage> _messages;
    int _row;
    int _column;
    Set<Object> _disableLocks;
    List<FormFieldListener> _changeListeners;
    boolean _listeningToEditor;

    FormField(FormBuilder<?> formBuilder) {
        logger.toString();
        this._messages = ListX.create();
        this._disableLocks = SetX.create();
        this._changeListeners = ListX.create();
        this._listeningToEditor = false;
        DependencyInjector.inject((Object)this);
        this._formBuilder = formBuilder;
    }

    public void setRequired(boolean bl) {
        this._required = bl;
        this._editor.setRequired(bl);
    }

    public void setEnabled(Object object, boolean bl) {
        if (!bl) {
            this._disableLocks.add(object);
        } else {
            this._disableLocks.remove(object);
        }
        boolean bl2 = bl = this._disableLocks.size() == 0;
        if (this._label != null) {
            this._label.setEnabled(bl);
        }
        if (this._editor != null) {
            this._editor.setEditable(bl);
        }
    }

    public boolean clearErrorMessagesForOwner(Object object) {
        boolean bl = false;
        for (ErrorMessage errorMessage : ListX.create(this._messages)) {
            if (!errorMessage.getOwner().equals(object)) continue;
            this._messages.remove(errorMessage);
            bl = true;
        }
        if (bl) {
            this.resetErrorMessageToolTip();
        }
        return bl;
    }

    public boolean clearAllErrorMessages() {
        if (this._messages.size() > 0) {
            this._messages.clear();
            this.resetErrorMessageToolTip();
            return true;
        }
        return false;
    }

    public boolean hasErrors() {
        return this._messages.size() > 0;
    }

    public void addErrorMessage(Object object, String string) {
        this._messages.add(new ErrorMessage(object, string));
        this.resetErrorMessageToolTip();
    }

    private void resetErrorMessageToolTip() {
        if (this.hasErrors()) {
            this.getErrorIcon().setVisible(true);
            this.getErrorIcon().setToolTipText(this._messages.get(0).getMessage());
        } else {
            this.getErrorIcon().setVisible(false);
        }
        this.getErrorIcon().repaint();
    }

    public JLabel getErrorIcon() {
        if (this._errorIcon == null) {
            this._errorIcon = this._iconFactory.createErrorIconLabel(this._editor.getWidget());
            this._errorIcon.setVisible(false);
            this._formBuilder.getFormContainers().getIconLayer().add(this._errorIcon);
        } else {
            try {
                if (!this._editor.getWidget().contains(this._errorIcon.getLocationOnScreen())) {
                    this._iconFactory.positionIcon(this._errorIcon, this._editor.getWidget(), false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this._errorIcon;
    }

    public void setRowAndColumn(int n, int n2) {
        this._row = n;
        this._column = n2;
    }

    public <T> Editor<T> getEditor() {
        return this._editor;
    }

    public String toString() {
        return this._property.toString();
    }

    public IPropertyContext getProperty() {
        return this._property;
    }

    public JLabel getLabel() {
        return this._label;
    }

    public void addFormFieldListener(FormFieldListener formFieldListener) {
        if (this._editor instanceof AbstractEditor) {
            if (!this._listeningToEditor) {
                this.initChangeListener();
            }
            this._changeListeners.add(formFieldListener);
        }
    }

    public void removeFormFieldListener(FormFieldListener formFieldListener) {
        this._changeListeners.remove(formFieldListener);
    }

    private void initChangeListener() {
        AbstractEditor abstractEditor = (AbstractEditor)this._editor;
        this._listeningToEditor = true;
        this._editor.addChangeListener(new MegaListener(abstractEditor, new MegaListenerAction(){

            @Override
            public void performAction() {
                for (FormFieldListener formFieldListener : FormField.this._changeListeners) {
                    formFieldListener.formFieldChanged(FormField.this);
                }
            }
        }));
    }
}

