/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing.beanprops.form;

import java.util.List;
import net.java.dev.properties.container.IPropertyContext;
import net.java.dev.properties.container.PropertyContextable;
import net.model3.collections.ListX;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3x.swing.beanprops.form.FormBuilder;

public class FormDefinition {
    private static final Logger logger = LoggerHelper.getLogger();
    int _columns = 2;
    Object[][] _layout;
    Class<?> _beanType;

    public FormDefinition() {
    }

    public FormDefinition(List<IPropertyContext> list) {
        this.setProperties(2, list);
    }

    public FormDefinition(int n, List<IPropertyContext> list) {
        this.setProperties(n, list);
    }

    public FormDefinition(Object[][] objectArray) {
        this._layout = objectArray;
    }

    public void setProperties(int n, List<IPropertyContext> list) {
        this._columns = n;
        List list2 = ListX.create();
        Object[] objectArray = null;
        int n2 = 0;
        for (PropertyContextable propertyContextable : list) {
            if (propertyContextable == null) continue;
            IPropertyContext iPropertyContext = propertyContextable.getContext();
            if (objectArray == null) {
                objectArray = new Object[n];
                list2.add(objectArray);
            }
            objectArray[n2] = iPropertyContext;
            if (++n2 < n) continue;
            objectArray = null;
            n2 = 0;
        }
        this._layout = (Object[][])list2.toArray((T[])new Object[0][0]);
    }

    public int getColumns() {
        return this._columns;
    }

    public void setColumns(int n) {
        this._columns = n;
    }

    public <T> FormBuilder<T> createFormBuilder() {
        FormBuilder formBuilder = new FormBuilder(this.getType());
        this.populateFormBuilder(formBuilder);
        return formBuilder;
    }

    public <T> FormBuilder<T> populateFormBuilder(FormBuilder<T> formBuilder) {
        Object[][] objectArray = this._layout;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Object[] objectArray2;
            for (Object object : objectArray2 = objectArray[i]) {
                if (object instanceof IPropertyContext) {
                    IPropertyContext iPropertyContext = (IPropertyContext)object;
                    formBuilder.addColumn((PropertyContextable)iPropertyContext);
                    continue;
                }
                if (object instanceof String) {
                    formBuilder.addSeperator((String)object);
                    continue;
                }
                if (object == null) {
                    formBuilder.addEmptyColumn();
                    continue;
                }
                logger.warn((Object)"don't know how to handle {} in a form layout", object);
            }
            formBuilder.nextRow();
        }
        return formBuilder;
    }

    public List<IPropertyContext> getFields() {
        List list = ListX.create();
        Object[][] objectArray = this._layout;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Object[] objectArray2;
            for (Object object : objectArray2 = objectArray[i]) {
                if (!(object instanceof IPropertyContext)) continue;
                list.add((IPropertyContext)object);
            }
        }
        return list;
    }

    Class<?> getType() {
        if (this._beanType == null) {
            Object[][] objectArray = this._layout;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object[] objectArray2;
                for (Object object : objectArray2 = objectArray[i]) {
                    if (!(object instanceof IPropertyContext)) continue;
                    this._beanType = ((IPropertyContext)object).getParentBeanContext().getType();
                    return this._beanType;
                }
            }
        }
        return this._beanType;
    }
}

