/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing.beanprops.form;

import com.google.inject.Inject;
import css.CssHelper;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import net.java.dev.properties.container.BeanContainer;
import net.java.dev.properties.container.IBeanContext;
import net.java.dev.properties.container.IPropertyContext;
import net.java.dev.properties.container.PropertyContextable;
import net.model3.collections.ListX;
import net.model3.collections.SetX;
import net.model3.guice.DependencyInjector;
import net.model3.lang.ClassX;
import net.model3.lang.ObjectX;
import net.model3.lang.Visitor;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;
import net.model3.swing.EventManager;
import net.model3.swing.GuiHelper;
import net.model3x.swing.ComponentFactory;
import net.model3x.swing.FocusMonitor;
import net.model3x.swing.IconFactory;
import net.model3x.swing.M3Layout;
import net.model3x.swing.beanprops.Required;
import net.model3x.swing.beanprops.editors.Editor;
import net.model3x.swing.beanprops.editors.EditorFactory;
import net.model3x.swing.beanprops.form.CellDefinition;
import net.model3x.swing.beanprops.form.FormAdapter;
import net.model3x.swing.beanprops.form.FormContainers;
import net.model3x.swing.beanprops.form.FormField;
import net.model3x.swing.beanprops.form.FormListener;

public class FormBuilder<T> {
    private static final Logger logger = LoggerHelper.getLogger();
    T _bean;
    IBeanContext _beanContext;
    boolean _enabled = true;
    boolean _populatingForm = false;
    List<FormField> _fields = ListX.create();
    List<FormField> _fieldsByRowColumn;
    Set<Editor<?>> _editorsWithChanges = SetX.create();
    List<IPropertyContext> _requiredFields = ListX.create();
    List<JComponent> _separators = ListX.create();
    int _nextColumn = 1;
    int _columns = 2;
    int _nextRow = 1;
    FormContainers _formContainers;
    boolean _initialized = false;
    JButton _saveButton;
    JButton _cancelButton;
    EventManager<FormListener<T>> _eventManager = EventManager.create();
    FocusMonitor _focusMonitor;
    @Inject
    IconFactory _iconFactory;
    @Inject
    EditorFactory _editorFactory;
    @Inject
    ComponentFactory _componentFactory;

    public FormBuilder(Class<?> clazz) {
        DependencyInjector.inject((Object)this);
        this.initPanels();
        this._beanContext = BeanContainer.get().getContext(clazz);
    }

    private void initPanels() {
        this._formContainers = new FormContainers(this);
    }

    public FormBuilder() {
        DependencyInjector.inject((Object)this);
        this.initPanels();
        Class clazz = ClassX.getParameterizedType(this.getClass());
        this._beanContext = BeanContainer.get().getContext(clazz);
    }

    public FormBuilder(IBeanContext iBeanContext) {
        DependencyInjector.inject((Object)this);
        this.initPanels();
        this._beanContext = iBeanContext;
    }

    public FormBuilder(T t, PropertyContextable ... propertyContextableArray) {
        DependencyInjector.inject((Object)this);
        this.initPanels();
        this._beanContext = BeanContainer.get().getContext(t);
        this.addColumns(propertyContextableArray);
        this.setBeanImpl(t);
    }

    FormBuilder(FormContainers formContainers) {
        DependencyInjector.inject((Object)this);
    }

    FormBuilder(Class<T> clazz, FormContainers formContainers) {
        DependencyInjector.inject((Object)this);
        this._beanContext = BeanContainer.get().getContext(clazz);
        this._formContainers = formContainers;
    }

    public FormField getField(IPropertyContext iPropertyContext) {
        for (FormField formField : this._fields) {
            if (!formField._property.equals(iPropertyContext)) continue;
            return formField;
        }
        throw new RuntimeException("no FieldWrapper found for " + iPropertyContext);
    }

    public void addColumns(PropertyContextable ... propertyContextableArray) {
        for (PropertyContextable propertyContextable : propertyContextableArray) {
            this.addColumn(propertyContextable);
        }
    }

    public FormField addColumn(CellDefinition cellDefinition) {
        FormField formField = this.addCellImpl(cellDefinition);
        if (this._nextColumn > this._columns) {
            this.nextRow();
        }
        return formField;
    }

    public FormField addColumn(PropertyContextable propertyContextable) {
        FormField formField = this.addCellImpl(new CellDefinition(propertyContextable.getContext()));
        if (this._nextColumn > this._columns) {
            this.nextRow();
        }
        return formField;
    }

    public void addRow(PropertyContextable ... propertyContextableArray) {
        for (PropertyContextable propertyContextable : propertyContextableArray) {
            this.addCellImpl(new CellDefinition(propertyContextable.getContext()));
        }
        this.nextRow();
    }

    public void nextRow() {
        ++this._nextRow;
        this._nextColumn = 0;
    }

    private FormField addCellImpl(CellDefinition cellDefinition) {
        FormField formField = null;
        if (cellDefinition.getPropertyContext() != null) {
            Editor<?> editor = this._editorFactory.getEditor((PropertyContextable)cellDefinition.getPropertyContext());
            if (editor == null) {
                logger.warn((Object)"No editor found for {}", (Object)cellDefinition.getPropertyContext());
                return null;
            }
            formField = new FormField(this);
            this._fields.add(formField);
            formField._property = cellDefinition.getPropertyContext();
            formField._editor = editor;
            editor.init(this, cellDefinition.getPropertyContext());
            editor.setEditable(cellDefinition.getPropertyContext().isWritable());
            formField._label = new JLabel(formField._editor.getProperty().getDisplayName() + ":");
            if (formField._property.getAnnotation(Required.class) != null || this._requiredFields.contains(formField._property)) {
                formField.setRequired(true);
            }
            JLabel jLabel = formField._label;
            JComponent jComponent = formField._editor.getWidget();
        } else {
            JLabel jLabel = new JLabel();
            JLabel jLabel2 = new JLabel();
        }
        boolean bl = false;
        if (this._nextColumn == 0) {
            this._nextColumn = 1;
            bl = true;
            ++this._nextRow;
        }
        this._formContainers._formFieldAdder.addFormField(this, formField, cellDefinition, bl);
        if (formField != null) {
            formField.setRowAndColumn(this._nextRow, this._nextColumn);
        }
        ++this._nextColumn;
        return formField;
    }

    public void addStatusAreaMessage(String string) {
        logger.warn((Object)"addStatusAreaMessage(\"{}\") but it isn't implemented yet", (Object)string, (Object)new Throwable());
    }

    public void populateForm() {
        this._populatingForm = true;
        if (this._bean == null) {
            this.setBeanImpl(this.newInstance());
        }
        for (FormField formField : this._fields) {
            formField._editor.populateWidget();
            formField._editor.validate();
        }
        this.clearChanges();
        this._populatingForm = false;
        this._eventManager.safeDispatch(new Visitor<FormListener<T>>(){

            public void visit(FormListener<T> formListener) {
                formListener.formPopulated(FormBuilder.this);
            }
        });
    }

    public JLayeredPane getForm() {
        if (!this._initialized) {
            this.initForm();
        }
        return this._formContainers.getForm();
    }

    public void addSeperator(String string) {
        JComponent jComponent = this._componentFactory.createTitledSeperator(string);
        this._separators.add(jComponent);
        this._formContainers._formFieldAdder.addSeperator(this, jComponent);
        this.nextRow();
    }

    private void initForm() {
        if (this._saveButton != null) {
            JPanel jPanel = new JPanel((LayoutManager)new M3Layout("insets 0"));
            CssHelper.addStyleClass((Component)jPanel, (String)"buttons");
            jPanel.add(this._saveButton);
            jPanel.add(this._cancelButton);
            this._formContainers.getFieldsPanel().add((Component)jPanel, "newline,span, align center,wrap");
        }
        this.populateForm();
        this._initialized = true;
        if (this._formContainers.getCommitOnFocusLostContainer() != null) {
            this._focusMonitor = new FocusMonitor(this._formContainers.getCommitOnFocusLostContainer());
            this._focusMonitor.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    if (focusEvent.getOppositeComponent() == null || !GuiHelper.isParent((Component)FormBuilder.this._formContainers.getCommitOnFocusLostContainer(), (Component)focusEvent.getOppositeComponent())) {
                        FormBuilder.this.saveChanges();
                    }
                }
            });
        }
    }

    public JButton getSaveButton() {
        if (this._saveButton == null) {
            this.enableButtons();
        }
        return this._saveButton;
    }

    public JButton getCancelButton() {
        if (this._cancelButton == null) {
            this.enableButtons();
        }
        return this._cancelButton;
    }

    public void addErrorMessage(PropertyContextable propertyContextable, Object object, String string) {
        this.getField(propertyContextable.getContext()).addErrorMessage(object, string);
        this.fireErrorMessagesChanged();
    }

    public void clearAllErrorMessagesForField(PropertyContextable propertyContextable) {
        this.getField(propertyContextable.getContext()).clearAllErrorMessages();
        this.fireErrorMessagesChanged();
    }

    public void clearErrorMessagesForOwner(Object object) {
        for (FormField formField : this._fields) {
            formField.clearErrorMessagesForOwner(object);
        }
        this.fireErrorMessagesChanged();
    }

    public void clearErrorMessages(PropertyContextable propertyContextable, Object object) {
        if (this.getField(propertyContextable.getContext()).clearErrorMessagesForOwner(object)) {
            this.fireErrorMessagesChanged();
        }
    }

    public T populateBean() {
        for (FormField formField : this._fields) {
            if (formField._editor.isEditable()) {
                formField._editor.populateBean();
            }
            formField._editor.validate();
        }
        return this._bean;
    }

    public T getBean() {
        return this._bean;
    }

    public void newBean() {
        this.setBeanImpl(this.newInstance());
        this.populateForm();
    }

    public void setBean(T t) {
        if (t == null) {
            this.setBeanImpl(null);
            this.disable();
        } else {
            this.enable(t);
        }
    }

    public void checkEditorForChanges(Editor<?> editor) {
        if (!this._populatingForm) {
            if (editor.hasChanges()) {
                logger.trace((Object)"added {} to list of editors with changes for form {}", editor, (Object)this);
                this._editorsWithChanges.add(editor);
            } else {
                logger.trace((Object)"removed {} from list of editors with changes for form {}", editor, (Object)this);
                this._editorsWithChanges.remove(editor);
            }
            this._eventManager.safeDispatch(new Visitor<FormListener<T>>(){

                public void visit(FormListener<T> formListener) {
                    formListener.formChanged(FormBuilder.this);
                }
            });
        }
    }

    public boolean hasChanges() {
        return this._editorsWithChanges.size() > 0;
    }

    public void clearChanges() {
        logger.trace((Object)"clearing changes on {}", (Object)this);
        this._editorsWithChanges.clear();
    }

    public void fireFocusLost() {
        this.saveChanges();
    }

    public final void saveChanges() {
        if (this.isEnabled() && !this.hasErrors() && this.hasChanges()) {
            this.populateBean();
            this.doSave();
            this.clearChanges();
        }
    }

    protected void doSave() {
        this._eventManager.safeDispatch(new Visitor<FormListener<T>>(){

            public void visit(FormListener<T> formListener) {
                formListener.formCommitted(FormBuilder.this);
            }
        });
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public void setEnabled(boolean bl) {
        this._formContainers.getFieldsPanel().setEnabled(bl);
    }

    void setEnabledImpl(boolean bl) {
        this._enabled = bl;
        for (FormField object : this._fields) {
            object._label.setEnabled(bl);
            if (!object._property.isWritable()) continue;
            object._editor.setEditable(bl);
        }
        for (JComponent jComponent : this._separators) {
            jComponent.setEnabled(bl);
        }
    }

    public T newInstance() {
        try {
            return this._beanContext.getType().newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void disable() {
        this.setBean(this.newInstance());
        this.populateForm();
        this.setEnabled(false);
        for (FormField formField : this._fields) {
            formField.getErrorIcon().setVisible(false);
            formField.getEditor().setEditable(false);
        }
    }

    public void enable(T t) {
        this.setEnabled(true);
        this.setBeanImpl(t);
        this.populateForm();
        for (FormField formField : this._fields) {
            formField.getEditor().setEditable(true);
        }
    }

    private void setBeanImpl(T t) {
        if (t != null && !ClassX.isAssignable((Class)this._beanContext.getType(), t.getClass())) {
            throw new IllegalArgumentException("expected a bean of type " + this._beanContext + " and got a bean of type " + t.getClass());
        }
        this._bean = t;
    }

    public void enableButtons() {
        if (this._saveButton == null) {
            this._saveButton = new JButton("Save");
            this._cancelButton = new JButton("Cancel");
        }
    }

    public boolean hasErrors() {
        for (FormField formField : this._fields) {
            if (!formField.hasErrors()) continue;
            return true;
        }
        return false;
    }

    public <U> Editor<U> getEditor(PropertyContextable propertyContextable) {
        propertyContextable = propertyContextable.getContext();
        for (FormField formField : this._fields) {
            if (!formField._property.equals(propertyContextable)) continue;
            return formField._editor;
        }
        return null;
    }

    public List<FormField> getFields() {
        return this._fields;
    }

    public List<FormField> getFieldsByRowColumn() {
        if (this._fieldsByRowColumn == null) {
            this._fieldsByRowColumn = ListX.create(this.getFields());
            Collections.sort(this._fieldsByRowColumn, new Comparator<FormField>(){

                @Override
                public int compare(FormField formField, FormField formField2) {
                    if (formField._column == formField2._column) {
                        return ObjectX.compareTo((Object)formField._row, (Object)formField2._row);
                    }
                    return ObjectX.compareTo((Object)formField._column, (Object)formField2._column);
                }
            });
        }
        return this._fieldsByRowColumn;
    }

    public boolean isInitialized() {
        return this._initialized;
    }

    void setInitialized(boolean bl) {
        this._initialized = bl;
    }

    public static <T> FormBuilder<T> create(Class<?> clazz) {
        return new FormBuilder<T>(clazz);
    }

    public int getColumns() {
        return this._columns;
    }

    public void setColumns(int n) {
        this._columns = n;
    }

    public void addColumns(List<IPropertyContext> list) {
        for (IPropertyContext iPropertyContext : list) {
            this.addColumn((PropertyContextable)iPropertyContext);
        }
    }

    public void addEmptyColumn() {
        this.addCellImpl(new CellDefinition(null));
    }

    public <U> U getValue(IPropertyContext iPropertyContext) {
        return (U)this.getField(iPropertyContext).getEditor().getValueFromWidget();
    }

    public Integer getEditorIndex(Component component) {
        FormField formField = this.getField(component);
        if (formField == null) {
            return null;
        }
        return this.getFieldsByRowColumn().indexOf(formField);
    }

    public FormField getField(Component component) {
        if (component instanceof JLabel) {
            for (FormField formField : this.getFields()) {
                if (formField._label != component) continue;
                return formField;
            }
        }
        return this.getFieldImpl(component);
    }

    private FormField getFieldImpl(Component component) {
        if (component == null) {
            return null;
        }
        if (component.getParent() == this._formContainers.getFieldsPanel()) {
            for (FormField formField : this.getFields()) {
                if (formField.getEditor().getWidget() != component) continue;
                return formField;
            }
            return null;
        }
        return this.getFieldImpl(component.getParent());
    }

    public void addListener(FormListener<T> formListener) {
        this._eventManager.addListener(formListener);
    }

    public void removeListener(FormListener<T> formListener) {
        this._eventManager.removeListener(formListener);
    }

    public void addRequiredFields(IPropertyContext ... iPropertyContextArray) {
        this._requiredFields.addAll(Arrays.asList(iPropertyContextArray));
    }

    public void setCommitOnFocusLostContainer(JComponent jComponent) {
        this._formContainers.setCommitOnFocusLostContainer(jComponent);
    }

    public String toString() {
        return "Form-" + ClassX.getShortName((Class)this._beanContext.getType()) + "@" + Integer.toHexString(System.identityHashCode(this));
    }

    void fireErrorMessagesChanged() {
        this._eventManager.safeDispatch(new Visitor<FormListener<T>>(){

            public void visit(FormListener<T> formListener) {
                formListener.errorMessagesChanged(FormBuilder.this);
            }
        });
    }

    public void configureAutoEnabledSaveButton() {
        this.addListener(new FormAdapter<T>(){

            @Override
            public void formPopulated(FormBuilder<T> formBuilder) {
                this.errorMessagesChanged(formBuilder);
            }

            @Override
            public void formChanged(FormBuilder<T> formBuilder) {
                this.errorMessagesChanged(formBuilder);
            }

            @Override
            public void errorMessagesChanged(FormBuilder<T> formBuilder) {
                if (formBuilder.hasErrors() || !formBuilder.hasChanges()) {
                    FormBuilder.this.getSaveButton().setEnabled(false);
                } else {
                    FormBuilder.this.getSaveButton().setEnabled(true);
                }
            }
        });
    }

    public FormContainers getFormContainers() {
        return this._formContainers;
    }

    public static interface SaveHandler<T> {
        public void doSave(FormBuilder<T> var1, T var2);
    }
}

