/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing.beanprops.editors;

import com.google.inject.Inject;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import net.model3.bean.ConverterFactory;
import net.model3.bean.converters.Converter;
import net.model3.guice.DependencyInjector;
import net.model3.lang.StringX;
import net.model3x.swing.beanprops.EditorAnno;
import net.model3x.swing.beanprops.editors.AbstractEditor;

public class TextFieldEditor<T>
extends AbstractEditor<T, JTextComponent> {
    Converter<T> _converter;
    @Inject
    ConverterFactory _converterFactory;

    public TextFieldEditor() {
        DependencyInjector.inject((Object)this);
    }

    public void setConverter(Converter<T> converter) {
        this._converter = converter;
    }

    public Converter<T> getConverter() {
        if (this._converter == null) {
            this._converter = this._converterFactory.getConverter(this.getProperty().getType());
        }
        return this._converter;
    }

    @Override
    public T getValueFromWidget() {
        String string = ((JTextComponent)this.getWidget()).getText();
        if (StringX.isBlank((String)string) && this.getProperty().isNullable()) {
            return null;
        }
        try {
            return (T)this.getConverter().stringToValue(this.getProperty().getType(), string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void setValueInWidget(T t) {
        String string = "";
        if (t != null) {
            string = this.getConverter().valueToString(t);
        }
        ((JTextComponent)this.getWidget()).setText(string);
    }

    @Override
    public JTextComponent initWidget() {
        int n = 10;
        EditorAnno editorAnno = (EditorAnno)this.getProperty().getAnnotation(EditorAnno.class);
        if (editorAnno != null && editorAnno.columnCount() > 0) {
            n = editorAnno.columnCount();
        }
        return new JTextField(n);
    }
}

