/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing.beanprops.editors;

import com.google.inject.Inject;
import com.google.inject.Injector;
import javax.swing.JTextField;
import net.model3x.swing.HStringProvider;
import net.model3x.swing.beanprops.editors.AbstractEditor;
import net.model3x.swing.textfield.MetaType;
import net.model3x.swing.textfield.TextFieldAdapterForMetaType;
import net.model3x.swing.textfield.TextFieldUtils;

public class MetaTypeEditor<T>
extends AbstractEditor<T, JTextField> {
    TextFieldAdapterForMetaType _textFieldAdapterForMetaType;
    HStringProvider.HStringAdapter<T> _stringAdapter;
    MetaType _metaType;
    @Inject
    Injector _injector;

    public void setMetaType(MetaType metaType) {
        this._metaType = metaType;
        this._stringAdapter = (HStringProvider.HStringAdapter)this._injector.getInstance(this._metaType.hstringAdapter());
    }

    @Override
    public T getValueFromWidget() {
        String string = this.filterChars(((JTextField)this.getWidget()).getText());
        return this._stringAdapter.stringToValue(this.getProperty().getType(), string);
    }

    @Override
    public JTextField initWidget() {
        JTextField jTextField = new JTextField(this._metaType.defaultLength());
        this._textFieldAdapterForMetaType = new TextFieldAdapterForMetaType(this._metaType);
        TextFieldUtils.decorate(jTextField, this._textFieldAdapterForMetaType, this._textFieldAdapterForMetaType.getMetaType().caseSensitivity());
        return jTextField;
    }

    @Override
    public void setValueInWidget(T t) {
        if (t == null) {
            ((JTextField)this.getWidget()).setText("");
        } else {
            ((JTextField)this.getWidget()).setText(this._stringAdapter.valueToString(t));
        }
    }

    String filterChars(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (char c : string.toCharArray()) {
            if (this._metaType.removeCharacters().indexOf(c) != -1) continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }
}

