/*
 * Decompiled with CFR 0.152.
 */
package net.model3x.swing.beanprops.editors;

import com.google.inject.Inject;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import net.model3.collections.ListX;
import net.model3x.swing.BeanListener;
import net.model3x.swing.ComponentFactory;
import net.model3x.swing.EntityComboBoxModel;
import net.model3x.swing.M3Panel;
import net.model3x.swing.beanprops.editors.AbstractEditor;

public class ListEditor<T>
extends AbstractEditor<List<T>, JComponent> {
    @Inject
    ComponentFactory _componentFactory;
    EntityModelJList _jlist;
    JButton _addButton;
    JButton _removeButton;

    @Override
    public JComponent initWidget() {
        M3Panel m3Panel = new M3Panel();
        m3Panel.getLayout().setRowConstraints("center");
        this._jlist = new EntityModelJList();
        JScrollPane jScrollPane = new JScrollPane(this._jlist);
        jScrollPane.setMinimumSize(new Dimension(250, 100));
        jScrollPane.setPreferredSize(new Dimension(400, 100));
        m3Panel.add((Component)jScrollPane, (Object)"grow");
        this._addButton = new JButton(new AbstractAction("Add"){
            private static final long serialVersionUID = -5644390861803492172L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ListEditor.this.showSelectionPopup();
            }
        });
        m3Panel.add((Component)this._addButton, (Object)"center");
        this._removeButton = new JButton(new AbstractAction("Remove"){
            private static final long serialVersionUID = -5644390861803492172L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = ListEditor.this._jlist.getSelectedIndices();
                if (nArray != null && nArray.length > 0) {
                    List list = ListX.create();
                    for (int n : nArray) {
                        list.add(((EntityComboBoxModel)ListEditor.this._jlist.getModel()).getEntityAt(n));
                    }
                    Object object = list.iterator();
                    while (object.hasNext()) {
                        Object e = object.next();
                        ((EntityComboBoxModel)ListEditor.this._jlist.getModel()).removeEntity(e);
                    }
                }
            }
        });
        m3Panel.add((Component)this._removeButton);
        return m3Panel;
    }

    @Override
    public List<T> getValueFromWidget() {
        List list = null;
        int n = ((EntityComboBoxModel)this._jlist.getModel()).getSize();
        if (n > 0) {
            list = ListX.create();
            for (int i = 0; i < n; ++i) {
                list.add(((EntityComboBoxModel)this._jlist.getModel()).getEntityAt(i));
            }
        }
        return list;
    }

    @Override
    public void setValueInWidget(List<T> list) {
        ListModel listModel = this._jlist.getModel();
        ((EntityComboBoxModel)listModel).setItems(list);
    }

    protected void addValueToWidget(T t) {
        if (!((EntityComboBoxModel)this._jlist.getModel()).containsEntity(t)) {
            ((EntityComboBoxModel)this._jlist.getModel()).addEntity(t);
        }
    }

    public void showSelectionPopup() {
        this._componentFactory.showEntitySelectionPopup((Component)this.getWidget(), this.getProperty(), (BeanListener<?>)new BeanListener<T>(){

            public void beanEvent(T t) {
                ListEditor.this.addValueToWidget(t);
            }
        });
    }

    class ReorderListener
    extends MouseAdapter {
        private EntityModelJList list;
        private int pressIndex = 0;
        private int releaseIndex = 0;

        public ReorderListener(EntityModelJList entityModelJList) {
            this.list = entityModelJList;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.pressIndex = this.list.locationToIndex(mouseEvent.getPoint());
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.releaseIndex = this.list.locationToIndex(mouseEvent.getPoint());
            if (this.releaseIndex != this.pressIndex && this.releaseIndex != -1) {
                this.reorder();
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            this.mouseReleased(mouseEvent);
            this.pressIndex = this.releaseIndex;
        }

        private void reorder() {
            ListModel listModel = this.list.getModel();
            Object t = ((EntityComboBoxModel)listModel).getEntityAt(this.pressIndex);
            ((EntityComboBoxModel)listModel).removeEntityAt(this.pressIndex);
            ((EntityComboBoxModel)listModel).addEntityAt(t, this.releaseIndex);
        }
    }

    public class EntityModelJList
    extends JList {
        private static final long serialVersionUID = 7982173047282641774L;
        private EntityComboBoxModel<T> _model = new EntityComboBoxModel();

        public EntityModelJList() {
            this.setModel(this._model);
            ReorderListener reorderListener = new ReorderListener(this);
            this.addMouseListener(reorderListener);
            this.addMouseMotionListener(reorderListener);
        }

        public EntityComboBoxModel<T> getModel() {
            return this._model;
        }
    }
}

